/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.UIManager;

public final class ExtBasicSpinnerLayout
implements LayoutManager {
    private static final Dimension ZERO_SIZE = new Dimension(0, 0);
    private Component nextButton = null;
    private Component previousButton = null;
    private Component editor = null;

    public void addLayoutComponent(String string, Component component) {
        if ("Next".equals(string)) {
            this.nextButton = component;
        } else if ("Previous".equals(string)) {
            this.previousButton = component;
        } else if ("Editor".equals(string)) {
            this.editor = component;
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.nextButton) {
            component = null;
        } else if (component == this.previousButton) {
            this.previousButton = null;
        } else if (component == this.editor) {
            this.editor = null;
        }
    }

    private Dimension preferredSize(Component component) {
        return component == null ? ZERO_SIZE : component.getPreferredSize();
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = this.preferredSize(this.nextButton);
        Dimension dimension2 = this.preferredSize(this.previousButton);
        Dimension dimension3 = this.preferredSize(this.editor);
        Dimension dimension4 = new Dimension(dimension3.width, dimension3.height);
        dimension4.width += Math.max(dimension.width, dimension2.width);
        Insets insets = container.getInsets();
        dimension4.width += insets.left + insets.right;
        dimension4.height += insets.top + insets.bottom;
        return dimension4;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    private void setBounds(Component component, int n, int n2, int n3, int n4) {
        if (component != null) {
            component.setBounds(n, n2, n3, n4);
        }
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        int n3;
        int n4 = container.getWidth();
        int n5 = container.getHeight();
        Insets insets = container.getInsets();
        Dimension dimension = this.preferredSize(this.nextButton);
        Dimension dimension2 = this.preferredSize(this.previousButton);
        int n6 = Math.max(dimension.width, dimension2.width);
        int n7 = n5 - (insets.top + insets.bottom);
        Insets insets2 = UIManager.getInsets("Spinner.arrowButtonInsets");
        if (insets2 == null) {
            insets2 = insets;
        }
        if (container.getComponentOrientation().isLeftToRight()) {
            n3 = insets.left;
            n2 = n4 - insets.left - n6 - insets2.right;
            n = n4 - n6 - insets2.right;
        } else {
            n = insets2.left;
            n3 = n + n6;
            n2 = n4 - insets2.left - n6 - insets.right;
        }
        int n8 = insets2.top;
        int n9 = n5 / 2 + n5 % 2 - n8;
        int n10 = insets2.top + n9;
        int n11 = n5 - n10 - insets2.bottom;
        this.setBounds(this.editor, n3, insets.top, n2, n7);
        this.setBounds(this.nextButton, n, n8, n6, n9);
        this.setBounds(this.previousButton, n, n10, n6, n11);
    }
}

