/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.CompoundDockable;
import com.vlsolutions.swing.docking.DockDropReceiver;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableContainerFactory;
import com.vlsolutions.swing.docking.SingleDockableContainer;
import com.vlsolutions.swing.docking.event.DockDragEvent;
import com.vlsolutions.swing.docking.event.DockDropEvent;
import com.vlsolutions.swing.docking.event.DockEvent;
import com.vlsolutions.swing.docking.event.DockingActionAddDockableEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CompoundDockingPanel
extends JPanel
implements DockDropReceiver {
    private CompoundDockable dockable;

    public CompoundDockingPanel(CompoundDockable dockable) {
        this.setLayout(new BorderLayout());
        this.dockable = dockable;
    }

    public void processDockableDrag(DockDragEvent event) {
        this.scanContainer(event, false);
    }

    public void processDockableDrop(DockDropEvent event) {
        this.scanContainer(event, true);
    }

    private void acceptDrop(DockEvent event) {
        ((DockDropEvent)event).acceptDrop();
        Dockable d = event.getDragSource().getDockable();
        SingleDockableContainer dockableContainer = DockableContainerFactory.getFactory().createDockableContainer(d, 0);
        dockableContainer.installDocking(event.getDesktop());
        this.add((Component)((JComponent)((Object)dockableContainer)), "Center");
    }

    private void scanContainer(DockEvent event, boolean drop) {
        if (event.getDragSource().getDockableContainer().isAncestorOf(this)) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).delegateDrag();
            }
            return;
        }
        Point p = event.getMouseEvent().getPoint();
        Rectangle compBounds = this.getBounds();
        Dockable dragged = event.getDragSource().getDockable();
        int initialState = dragged.getDockKey().getDockableState();
        int nextState = this.dockable.getDockKey().getDockableState();
        event.setDockingAction(new DockingActionAddDockableEvent(event.getDesktop(), dragged, initialState, nextState, this));
        if (drop) {
            this.acceptDrop(event);
        } else {
            Rectangle2D.Float r2d = new Rectangle2D.Float(0.0f, 0.0f, compBounds.width, compBounds.height);
            ((DockDragEvent)event).acceptDrag(r2d);
        }
    }

    public CompoundDockable getDockable() {
        return this.dockable;
    }
}

