/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.util.TimeZone;
import sun.util.calendar.AbstractCalendar;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarUtils;

public abstract class BaseCalendar
extends AbstractCalendar {
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    private static final int BASE_YEAR = 1970;
    private static final int[] FIXED_DATES = new int[]{719163, 719528, 719893, 720259, 720624, 720989, 721354, 721720, 722085, 722450, 722815, 723181, 723546, 723911, 724276, 724642, 725007, 725372, 725737, 726103, 726468, 726833, 727198, 727564, 727929, 728294, 728659, 729025, 729390, 729755, 730120, 730486, 730851, 731216, 731581, 731947, 732312, 732677, 733042, 733408, 733773, 734138, 734503, 734869, 735234, 735599, 735964, 736330, 736695, 737060, 737425, 737791, 738156, 738521, 738886, 739252, 739617, 739982, 740347, 740713, 741078, 741443, 741808, 742174, 742539, 742904, 743269, 743635, 744000, 744365};
    static final int[] DAYS_IN_MONTH = new int[]{31, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int[] ACCUMULATED_DAYS_IN_MONTH = new int[]{-30, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    static final int[] ACCUMULATED_DAYS_IN_MONTH_LEAP = new int[]{-30, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};

    public boolean validate(CalendarDate calendarDate) {
        Date date = (Date)calendarDate;
        if (date.isNormalized()) {
            return true;
        }
        int n2 = date.getMonth();
        if (n2 < 1 || n2 > 12) {
            return false;
        }
        int n3 = date.getDayOfMonth();
        if (n3 <= 0 || n3 > this.getMonthLength(date.getNormalizedYear(), n2)) {
            return false;
        }
        int n4 = date.getDayOfWeek();
        if (n4 != Integer.MIN_VALUE && n4 != this.getDayOfWeek(date)) {
            return false;
        }
        if (!this.validateTime(calendarDate)) {
            return false;
        }
        date.setNormalized(true);
        return true;
    }

    public boolean normalize(CalendarDate calendarDate) {
        if (calendarDate.isNormalized()) {
            return true;
        }
        Date date = (Date)calendarDate;
        TimeZone timeZone = date.getZone();
        if (timeZone != null) {
            this.getTime(calendarDate);
            return true;
        }
        int n2 = this.normalizeTime(date);
        this.normalizeMonth(date);
        long l2 = (long)date.getDayOfMonth() + (long)n2;
        int n3 = date.getMonth();
        int n4 = date.getNormalizedYear();
        int n5 = this.getMonthLength(n4, n3);
        if (l2 <= 0L || l2 > (long)n5) {
            if (l2 <= 0L && l2 > -28L) {
                n5 = this.getMonthLength(n4, --n3);
                date.setDayOfMonth((int)(l2 += (long)n5));
                if (n3 == 0) {
                    n3 = 12;
                    date.setNormalizedYear(n4 - 1);
                }
                date.setMonth(n3);
            } else if (l2 > (long)n5 && l2 < (long)(n5 + 28)) {
                date.setDayOfMonth((int)(l2 -= (long)n5));
                if (++n3 > 12) {
                    date.setNormalizedYear(n4 + 1);
                    n3 = 1;
                }
                date.setMonth(n3);
            } else {
                long l3 = l2 + this.getFixedDate(n4, n3, 1, date) - 1L;
                this.getCalendarDateFromFixedDate(date, l3);
            }
        } else {
            date.setDayOfWeek(this.getDayOfWeek(date));
        }
        calendarDate.setLeapYear(this.isLeapYear(date.getNormalizedYear()));
        calendarDate.setZoneOffset(0);
        calendarDate.setDaylightSaving(0);
        date.setNormalized(true);
        return true;
    }

    void normalizeMonth(CalendarDate calendarDate) {
        Date date = (Date)calendarDate;
        int n2 = date.getNormalizedYear();
        long l2 = date.getMonth();
        if (l2 <= 0L) {
            long l3 = 1L - l2;
            l2 = 13L - l3 % 12L;
            date.setNormalizedYear(n2 -= (int)(l3 / 12L + 1L));
            date.setMonth((int)l2);
        } else if (l2 > 12L) {
            n2 += (int)((l2 - 1L) / 12L);
            l2 = (l2 - 1L) % 12L + 1L;
            date.setNormalizedYear(n2);
            date.setMonth((int)l2);
        }
    }

    public int getYearLength(CalendarDate calendarDate) {
        return this.isLeapYear(((Date)calendarDate).getNormalizedYear()) ? 366 : 365;
    }

    public int getYearLengthInMonths(CalendarDate calendarDate) {
        return 12;
    }

    public int getMonthLength(CalendarDate calendarDate) {
        Date date = (Date)calendarDate;
        int n2 = date.getMonth();
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Illegal month value: " + n2);
        }
        return this.getMonthLength(date.getNormalizedYear(), n2);
    }

    private final int getMonthLength(int n2, int n3) {
        int n4 = DAYS_IN_MONTH[n3];
        if (n3 == 2 && this.isLeapYear(n2)) {
            ++n4;
        }
        return n4;
    }

    public long getDayOfYear(CalendarDate calendarDate) {
        return this.getDayOfYear(((Date)calendarDate).getNormalizedYear(), calendarDate.getMonth(), calendarDate.getDayOfMonth());
    }

    final long getDayOfYear(int n2, int n3, int n4) {
        return (long)n4 + (long)(this.isLeapYear(n2) ? ACCUMULATED_DAYS_IN_MONTH_LEAP[n3] : ACCUMULATED_DAYS_IN_MONTH[n3]);
    }

    public long getFixedDate(CalendarDate calendarDate) {
        if (!calendarDate.isNormalized()) {
            this.normalizeMonth(calendarDate);
        }
        return this.getFixedDate(((Date)calendarDate).getNormalizedYear(), calendarDate.getMonth(), calendarDate.getDayOfMonth(), (Date)calendarDate);
    }

    public long getFixedDate(int n2, int n3, int n4, Date date) {
        boolean bl2;
        boolean bl3 = bl2 = n3 == 1 && n4 == 1;
        if (date != null && date.hit(n2)) {
            if (bl2) {
                return date.getCachedJan1();
            }
            return date.getCachedJan1() + this.getDayOfYear(n2, n3, n4) - 1L;
        }
        int n5 = n2 - 1970;
        if (n5 >= 0 && n5 < FIXED_DATES.length) {
            long l2 = FIXED_DATES[n5];
            if (date != null) {
                date.setCache(n2, l2, this.isLeapYear(n2) ? 366 : 365);
            }
            return bl2 ? l2 : l2 + this.getDayOfYear(n2, n3, n4) - 1L;
        }
        long l3 = (long)n2 - 1L;
        long l4 = n4;
        l4 = l3 >= 0L ? (l4 += 365L * l3 + l3 / 4L - l3 / 100L + l3 / 400L + (long)((367 * n3 - 362) / 12)) : (l4 += 365L * l3 + CalendarUtils.floorDivide(l3, 4L) - CalendarUtils.floorDivide(l3, 100L) + CalendarUtils.floorDivide(l3, 400L) + (long)CalendarUtils.floorDivide(367 * n3 - 362, 12));
        if (n3 > 2) {
            l4 -= this.isLeapYear(n2) ? 1L : 2L;
        }
        if (date != null && bl2) {
            date.setCache(n2, l4, this.isLeapYear(n2) ? 366 : 365);
        }
        return l4;
    }

    public void getCalendarDateFromFixedDate(CalendarDate calendarDate, long l2) {
        int n2;
        boolean bl2;
        long l3;
        int n3;
        Date date = (Date)calendarDate;
        if (date.hit(l2)) {
            n3 = date.getCachedYear();
            l3 = date.getCachedJan1();
            bl2 = this.isLeapYear(n3);
        } else {
            n3 = this.getGregorianYearFromFixedDate(l2);
            l3 = this.getFixedDate(n3, 1, 1, null);
            bl2 = this.isLeapYear(n3);
            date.setCache(n3, l3, bl2 ? 366 : 365);
        }
        int n4 = (int)(l2 - l3);
        long l4 = l3 + 31L + 28L;
        if (bl2) {
            ++l4;
        }
        if (l2 >= l4) {
            n4 += bl2 ? 1 : 2;
        }
        n2 = (n2 = 12 * n4 + 373) > 0 ? (n2 /= 367) : CalendarUtils.floorDivide(n2, 367);
        long l5 = l3 + (long)ACCUMULATED_DAYS_IN_MONTH[n2];
        if (bl2 && n2 >= 3) {
            ++l5;
        }
        int n5 = (int)(l2 - l5) + 1;
        int n6 = BaseCalendar.getDayOfWeekFromFixedDate(l2);
        assert (n6 > 0) : "negative day of week " + n6;
        date.setNormalizedYear(n3);
        date.setMonth(n2);
        date.setDayOfMonth(n5);
        date.setDayOfWeek(n6);
        date.setLeapYear(bl2);
        date.setNormalized(true);
    }

    public int getDayOfWeek(CalendarDate calendarDate) {
        long l2 = this.getFixedDate(calendarDate);
        return BaseCalendar.getDayOfWeekFromFixedDate(l2);
    }

    public static final int getDayOfWeekFromFixedDate(long l2) {
        if (l2 >= 0L) {
            return (int)(l2 % 7L) + 1;
        }
        return (int)CalendarUtils.mod(l2, 7L) + 1;
    }

    public int getYearFromFixedDate(long l2) {
        return this.getGregorianYearFromFixedDate(l2);
    }

    final int getGregorianYearFromFixedDate(long l2) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (l2 > 0L) {
            long l3 = l2 - 1L;
            n5 = (int)(l3 / 146097L);
            int n6 = (int)(l3 % 146097L);
            n4 = n6 / 36524;
            int n7 = n6 % 36524;
            n3 = n7 / 1461;
            int n8 = n7 % 1461;
            n2 = n8 / 365;
            int n9 = n8 % 365 + 1;
        } else {
            long l4 = l2 - 1L;
            n5 = (int)CalendarUtils.floorDivide(l4, 146097L);
            int n10 = (int)CalendarUtils.mod(l4, 146097L);
            n4 = CalendarUtils.floorDivide(n10, 36524);
            int n11 = CalendarUtils.mod(n10, 36524);
            n3 = CalendarUtils.floorDivide(n11, 1461);
            int n12 = CalendarUtils.mod(n11, 1461);
            n2 = CalendarUtils.floorDivide(n12, 365);
            int n13 = CalendarUtils.mod(n12, 365) + 1;
        }
        int n14 = 400 * n5 + 100 * n4 + 4 * n3 + n2;
        if (n4 != 4 && n2 != 4) {
            ++n14;
        }
        return n14;
    }

    protected boolean isLeapYear(CalendarDate calendarDate) {
        return this.isLeapYear(((Date)calendarDate).getNormalizedYear());
    }

    boolean isLeapYear(int n2) {
        return CalendarUtils.isGregorianLeapYear(n2);
    }

    public static abstract class Date
    extends CalendarDate {
        int cachedYear = 2004;
        long cachedFixedDateJan1 = 731581L;
        long cachedFixedDateNextJan1 = this.cachedFixedDateJan1 + 366L;

        protected Date() {
        }

        protected Date(TimeZone timeZone) {
            super(timeZone);
        }

        public Date setNormalizedDate(int n2, int n3, int n4) {
            this.setNormalizedYear(n2);
            this.setMonth(n3).setDayOfMonth(n4);
            return this;
        }

        public abstract int getNormalizedYear();

        public abstract void setNormalizedYear(int var1);

        protected final boolean hit(int n2) {
            return n2 == this.cachedYear;
        }

        protected final boolean hit(long l2) {
            return l2 >= this.cachedFixedDateJan1 && l2 < this.cachedFixedDateNextJan1;
        }

        protected int getCachedYear() {
            return this.cachedYear;
        }

        protected long getCachedJan1() {
            return this.cachedFixedDateJan1;
        }

        protected void setCache(int n2, long l2, int n3) {
            this.cachedYear = n2;
            this.cachedFixedDateJan1 = l2;
            this.cachedFixedDateNextJan1 = l2 + (long)n3;
        }
    }
}

