/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ImageConsumer;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.InputStreamImageSource;

class ImageConsumerQueue {
    ImageConsumerQueue next;
    ImageConsumer consumer;
    boolean interested;
    Object securityContext;
    boolean secure;

    static ImageConsumerQueue removeConsumer(ImageConsumerQueue imageConsumerQueue, ImageConsumer imageConsumer, boolean bl2) {
        ImageConsumerQueue imageConsumerQueue2 = null;
        ImageConsumerQueue imageConsumerQueue3 = imageConsumerQueue;
        while (imageConsumerQueue3 != null) {
            if (imageConsumerQueue3.consumer == imageConsumer) {
                if (imageConsumerQueue2 == null) {
                    imageConsumerQueue = imageConsumerQueue3.next;
                } else {
                    imageConsumerQueue2.next = imageConsumerQueue3.next;
                }
                imageConsumerQueue3.interested = bl2;
                break;
            }
            imageConsumerQueue2 = imageConsumerQueue3;
            imageConsumerQueue3 = imageConsumerQueue3.next;
        }
        return imageConsumerQueue;
    }

    static boolean isConsumer(ImageConsumerQueue imageConsumerQueue, ImageConsumer imageConsumer) {
        ImageConsumerQueue imageConsumerQueue2 = imageConsumerQueue;
        while (imageConsumerQueue2 != null) {
            if (imageConsumerQueue2.consumer == imageConsumer) {
                return true;
            }
            imageConsumerQueue2 = imageConsumerQueue2.next;
        }
        return false;
    }

    ImageConsumerQueue(InputStreamImageSource inputStreamImageSource, ImageConsumer imageConsumer) {
        this.consumer = imageConsumer;
        this.interested = true;
        if (imageConsumer instanceof ImageRepresentation) {
            ImageRepresentation imageRepresentation = (ImageRepresentation)imageConsumer;
            if (imageRepresentation.image.source != inputStreamImageSource) {
                throw new SecurityException("ImageRep added to wrong image source");
            }
            this.secure = true;
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            this.securityContext = securityManager != null ? securityManager.getSecurityContext() : null;
        }
    }

    public String toString() {
        return "[" + this.consumer + ", " + (this.interested ? "" : "not ") + "interested" + (this.securityContext != null ? ", " + this.securityContext : "") + "]";
    }
}

