/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.HashSet;
import sun.awt.X11GraphicsConfig;
import sun.java2d.opengl.GLXGraphicsConfig;

public class X11GraphicsDevice
extends GraphicsDevice {
    int screen;
    private static DisplayMode displayMode;
    GraphicsConfiguration[] configs;
    GraphicsConfiguration defaultConfig;
    HashSet doubleBufferVisuals;

    public X11GraphicsDevice(int n2) {
        this.screen = n2;
    }

    private static native void initIDs();

    public int getScreen() {
        return this.screen;
    }

    public native long getDisplay();

    public int getType() {
        return 0;
    }

    public String getIDstring() {
        return ":0." + this.screen;
    }

    public GraphicsConfiguration[] getConfigurations() {
        GraphicsConfiguration[] graphicsConfigurationArray = this.configs;
        if (graphicsConfigurationArray == null) {
            int n2 = 1;
            int n3 = this.getNumConfigs(this.screen);
            graphicsConfigurationArray = new GraphicsConfiguration[n3];
            graphicsConfigurationArray[0] = this.defaultConfig == null ? this.getDefaultConfiguration() : this.defaultConfig;
            boolean bl2 = GLXGraphicsConfig.isGLXAvailable();
            boolean bl3 = X11GraphicsDevice.isDBESupported();
            if (bl3 && this.doubleBufferVisuals == null) {
                this.doubleBufferVisuals = new HashSet();
                this.getDoubleBufferVisuals(this.screen);
            }
            while (n2 < n3) {
                int n4 = this.getConfigVisualId(n2, this.screen);
                int n5 = this.getConfigDepth(n2, this.screen);
                if (bl2) {
                    graphicsConfigurationArray[n2] = GLXGraphicsConfig.getConfig(this, n4);
                }
                if (graphicsConfigurationArray[n2] == null) {
                    boolean bl4 = bl3 && this.doubleBufferVisuals.contains(new Integer(n4));
                    graphicsConfigurationArray[n2] = X11GraphicsConfig.getConfig(this, n4, n5, this.getConfigColormap(n2, this.screen), bl4);
                }
                ++n2;
            }
            this.configs = graphicsConfigurationArray;
        }
        return graphicsConfigurationArray;
    }

    public native int getNumConfigs(int var1);

    public native int getConfigVisualId(int var1, int var2);

    public native int getConfigDepth(int var1, int var2);

    public native int getConfigColormap(int var1, int var2);

    public static native boolean isDBESupported();

    private void addDoubleBufferVisual(int n2) {
        this.doubleBufferVisuals.add(new Integer(n2));
    }

    private native void getDoubleBufferVisuals(int var1);

    public GraphicsConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            int n2 = this.getConfigVisualId(0, this.screen);
            int n3 = this.getConfigDepth(0, this.screen);
            if (GLXGraphicsConfig.isGLXAvailable()) {
                this.defaultConfig = GLXGraphicsConfig.getConfig(this, n2);
                if (GLXGraphicsConfig.isGLXVerbose()) {
                    if (this.defaultConfig != null) {
                        System.out.print("OpenGL pipeline enabled");
                    } else {
                        System.out.print("Could not enable OpenGL pipeline");
                    }
                    System.out.println(" for default config on screen " + this.screen);
                }
            }
            if (this.defaultConfig == null) {
                boolean bl2 = false;
                if (X11GraphicsDevice.isDBESupported() && this.doubleBufferVisuals == null) {
                    this.doubleBufferVisuals = new HashSet();
                    this.getDoubleBufferVisuals(this.screen);
                    bl2 = this.doubleBufferVisuals.contains(new Integer(n2));
                }
                this.defaultConfig = X11GraphicsConfig.getConfig(this, n2, n3, this.getConfigColormap(0, this.screen), bl2);
            }
        }
        return this.defaultConfig;
    }

    public DisplayMode getDisplayMode() {
        if (displayMode == null) {
            GraphicsConfiguration graphicsConfiguration = this.getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            displayMode = new DisplayMode(rectangle.width, rectangle.height, -1, 0);
        }
        return displayMode;
    }

    public String toString() {
        return "X11GraphicsDevice[screen=" + this.screen + "]";
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            X11GraphicsDevice.initIDs();
        }
    }
}

