/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Segment;

public abstract class AbstractWriter {
    private ElementIterator it;
    private Writer out;
    private int indentLevel = 0;
    private int indentSpace = 2;
    private Document doc = null;
    private int maxLineLength = 100;
    private int currLength = 0;
    private int startOffset = 0;
    private int endOffset = 0;
    private int offsetIndent = 0;
    private String lineSeparator;
    private boolean canWrapLines;
    private boolean isLineEmpty;
    private char[] indentChars;
    private char[] tempChars;
    private char[] newlineChars;
    private Segment segment;
    protected static final char NEWLINE = '\n';

    protected AbstractWriter(Writer writer, Document document) {
        this(writer, document, 0, document.getLength());
    }

    protected AbstractWriter(Writer writer, Document document, int n2, int n3) {
        this.doc = document;
        this.it = new ElementIterator(document.getDefaultRootElement());
        this.out = writer;
        this.startOffset = n2;
        this.endOffset = n2 + n3;
        Object object = document.getProperty("__EndOfLine__");
        if (object instanceof String) {
            this.setLineSeparator((String)object);
        } else {
            String string = null;
            try {
                string = System.getProperty("line.separator");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string == null) {
                string = "\n";
            }
            this.setLineSeparator(string);
        }
        this.canWrapLines = true;
    }

    protected AbstractWriter(Writer writer, Element element) {
        this(writer, element, 0, element.getEndOffset());
    }

    protected AbstractWriter(Writer writer, Element element, int n2, int n3) {
        this.doc = element.getDocument();
        this.it = new ElementIterator(element);
        this.out = writer;
        this.startOffset = n2;
        this.endOffset = n2 + n3;
        this.canWrapLines = true;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    protected ElementIterator getElementIterator() {
        return this.it;
    }

    protected Writer getWriter() {
        return this.out;
    }

    protected Document getDocument() {
        return this.doc;
    }

    protected boolean inRange(Element element) {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        return element.getStartOffset() >= n2 && element.getStartOffset() < n3 || n2 >= element.getStartOffset() && n2 < element.getEndOffset();
    }

    protected abstract void write() throws IOException, BadLocationException;

    protected String getText(Element element) throws BadLocationException {
        return this.doc.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
    }

    protected void text(Element element) throws BadLocationException, IOException {
        int n2;
        int n3 = Math.max(this.getStartOffset(), element.getStartOffset());
        if (n3 < (n2 = Math.min(this.getEndOffset(), element.getEndOffset()))) {
            if (this.segment == null) {
                this.segment = new Segment();
            }
            this.getDocument().getText(n3, n2 - n3, this.segment);
            if (this.segment.count > 0) {
                this.write(this.segment.array, this.segment.offset, this.segment.count);
            }
        }
    }

    protected void setLineLength(int n2) {
        this.maxLineLength = n2;
    }

    protected int getLineLength() {
        return this.maxLineLength;
    }

    protected void setCurrentLineLength(int n2) {
        this.currLength = n2;
        this.isLineEmpty = this.currLength == 0;
    }

    protected int getCurrentLineLength() {
        return this.currLength;
    }

    protected boolean isLineEmpty() {
        return this.isLineEmpty;
    }

    protected void setCanWrapLines(boolean bl2) {
        this.canWrapLines = bl2;
    }

    protected boolean getCanWrapLines() {
        return this.canWrapLines;
    }

    protected void setIndentSpace(int n2) {
        this.indentSpace = n2;
    }

    protected int getIndentSpace() {
        return this.indentSpace;
    }

    public void setLineSeparator(String string) {
        this.lineSeparator = string;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    protected void incrIndent() {
        if (this.offsetIndent > 0) {
            ++this.offsetIndent;
        } else if (++this.indentLevel * this.getIndentSpace() >= this.getLineLength()) {
            ++this.offsetIndent;
            --this.indentLevel;
        }
    }

    protected void decrIndent() {
        if (this.offsetIndent > 0) {
            --this.offsetIndent;
        } else {
            --this.indentLevel;
        }
    }

    protected int getIndentLevel() {
        return this.indentLevel;
    }

    protected void indent() throws IOException {
        int n2;
        int n3 = this.getIndentLevel() * this.getIndentSpace();
        if (this.indentChars == null || n3 > this.indentChars.length) {
            this.indentChars = new char[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.indentChars[n2] = 32;
            }
        }
        n2 = this.getCurrentLineLength();
        boolean bl2 = this.isLineEmpty();
        this.output(this.indentChars, 0, n3);
        if (bl2 && n2 == 0) {
            this.isLineEmpty = true;
        }
    }

    protected void write(char c2) throws IOException {
        if (this.tempChars == null) {
            this.tempChars = new char[128];
        }
        this.tempChars[0] = c2;
        this.write(this.tempChars, 0, 1);
    }

    protected void write(String string) throws IOException {
        if (string == null) {
            return;
        }
        int n2 = string.length();
        if (this.tempChars == null || this.tempChars.length < n2) {
            this.tempChars = new char[n2];
        }
        string.getChars(0, n2, this.tempChars, 0);
        this.write(this.tempChars, 0, n2);
    }

    protected void writeLineSeparator() throws IOException {
        String string = this.getLineSeparator();
        int n2 = string.length();
        if (this.newlineChars == null || this.newlineChars.length < n2) {
            this.newlineChars = new char[n2];
        }
        string.getChars(0, n2, this.newlineChars, 0);
        this.output(this.newlineChars, 0, n2);
        this.setCurrentLineLength(0);
    }

    protected void write(char[] cArray, int n2, int n3) throws IOException {
        if (!this.getCanWrapLines()) {
            int n4 = n2;
            int n5 = n2 + n3;
            int n6 = this.indexOf(cArray, '\n', n2, n5);
            while (n6 != -1) {
                if (n6 > n4) {
                    this.output(cArray, n4, n6 - n4);
                }
                this.writeLineSeparator();
                n4 = n6 + 1;
                n6 = this.indexOf(cArray, '\n', n4, n5);
            }
            if (n4 < n5) {
                this.output(cArray, n4, n5 - n4);
            }
        } else {
            int n7 = n2;
            int n8 = n2 + n3;
            int n9 = this.getCurrentLineLength();
            int n10 = this.getLineLength();
            while (n7 < n8) {
                int n11 = this.indexOf(cArray, '\n', n7, n8);
                boolean bl2 = false;
                boolean bl3 = false;
                n9 = this.getCurrentLineLength();
                if (n11 != -1 && n9 + (n11 - n7) < n10) {
                    if (n11 > n7) {
                        this.output(cArray, n7, n11 - n7);
                    }
                    n7 = n11 + 1;
                    bl3 = true;
                } else if (n11 == -1 && n9 + (n8 - n7) < n10) {
                    if (n8 > n7) {
                        this.output(cArray, n7, n8 - n7);
                    }
                    n7 = n8;
                } else {
                    int n12;
                    int n13 = -1;
                    int n14 = Math.min(n8 - n7, n10 - n9 - 1);
                    for (n12 = 0; n12 < n14; ++n12) {
                        if (!Character.isWhitespace(cArray[n12 + n7])) continue;
                        n13 = n12;
                    }
                    if (n13 != -1) {
                        this.output(cArray, n7, (n13 += n7 + 1) - n7);
                        n7 = n13;
                        bl2 = true;
                    } else {
                        n12 = Math.max(0, n14);
                        n14 = n8 - n7;
                        while (n12 < n14) {
                            if (Character.isWhitespace(cArray[n12 + n7])) {
                                n13 = n12;
                                break;
                            }
                            ++n12;
                        }
                        if (n13 == -1) {
                            this.output(cArray, n7, n8 - n7);
                            n13 = n8;
                        } else if (cArray[n13 += n7] == '\n') {
                            this.output(cArray, n7, n13++ - n7);
                            bl3 = true;
                        } else {
                            this.output(cArray, n7, ++n13 - n7);
                            bl2 = true;
                        }
                        n7 = n13;
                    }
                }
                if (!bl3 && !bl2 && n7 >= n8) continue;
                this.writeLineSeparator();
                if (n7 >= n8 && bl3) continue;
                this.indent();
            }
        }
    }

    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            this.write(" " + obj + "=" + attributeSet.getAttribute(obj));
        }
    }

    protected void output(char[] cArray, int n2, int n3) throws IOException {
        this.getWriter().write(cArray, n2, n3);
        this.setCurrentLineLength(this.getCurrentLineLength() + n3);
    }

    private int indexOf(char[] cArray, char c2, int n2, int n3) {
        while (n2 < n3) {
            if (cArray[n2] == c2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }
}

