/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthArrowButton;
import javax.swing.plaf.synth.SynthComboPopup;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthComboBoxUI
extends BasicComboBoxUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private boolean useListColors;

    SynthComboBoxUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthComboBoxUI();
    }

    protected void installDefaults() {
        this.updateStyle(this.comboBox);
    }

    private void updateStyle(JComboBox jComboBox) {
        SynthStyle synthStyle = this.style;
        SynthContext synthContext = this.getContext(jComboBox, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.useListColors = this.style.getBoolean(synthContext, "ComboBox.rendererUseListColors", true);
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
    }

    protected void installListeners() {
        this.comboBox.addPropertyChangeListener(this);
        super.installListeners();
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.comboBox, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        this.comboBox.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    protected ComboPopup createPopup() {
        SynthComboPopup synthComboPopup = new SynthComboPopup(this.comboBox);
        return synthComboPopup;
    }

    protected ListCellRenderer createRenderer() {
        return new SynthComboBoxRenderer();
    }

    protected ComboBoxEditor createEditor() {
        return new SynthComboBoxEditor();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle(this.comboBox);
        }
    }

    protected JButton createArrowButton() {
        SynthArrowButton synthArrowButton = new SynthArrowButton(5);
        synthArrowButton.setName("ComboBox.arrowButton");
        return synthArrowButton;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintComboBoxBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValue(graphics, rectangle, this.hasFocus);
        }
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintComboBoxBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl2) {
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        Component component = bl2 && !this.isPopupVisible(this.comboBox) ? listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false) : listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        boolean bl3 = false;
        if (component instanceof JPanel) {
            bl3 = true;
        }
        if (component instanceof UIResource) {
            component.setName("ComboBox.renderer");
            this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl3);
        } else {
            this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl3);
        }
    }

    private static class SynthComboBoxEditor
    implements ComboBoxEditor,
    UIResource {
        protected JTextField editor = new JTextField("", 9);
        private Object oldValue;

        public SynthComboBoxEditor() {
            this.editor.setName("ComboBox.textField");
        }

        public Component getEditorComponent() {
            return this.editor;
        }

        public void setItem(Object object) {
            String string;
            if (object != null) {
                string = object.toString();
                this.oldValue = object;
            } else {
                string = "";
            }
            if (!string.equals(this.editor.getText())) {
                this.editor.setText(string);
            }
        }

        public Object getItem() {
            Object object = this.editor.getText();
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                if (object.equals(this.oldValue.toString())) {
                    return this.oldValue;
                }
                Class<? extends Object> clazz = this.oldValue.getClass();
                try {
                    Method method = clazz.getMethod("valueOf", String.class);
                    object = method.invoke(this.oldValue, this.editor.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object;
        }

        public void selectAll() {
            this.editor.selectAll();
            this.editor.requestFocus();
        }

        public void addActionListener(ActionListener actionListener) {
            this.editor.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.editor.removeActionListener(actionListener);
        }
    }

    private class SynthComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public SynthComboBoxRenderer() {
            this.setText(" ");
        }

        public String getName() {
            String string = super.getName();
            if (string == null) {
                return "ComboBox.renderer";
            }
            return string;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            this.setName("ComboBox.listRenderer");
            SynthLookAndFeel.resetSelectedUI();
            if (bl2) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
                if (!SynthComboBoxUI.this.useListColors) {
                    SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), bl2, bl3, jList.isEnabled());
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setFont(jList.getFont());
            if (object instanceof Icon) {
                this.setIcon((Icon)object);
                this.setText("");
            } else {
                String string;
                String string2 = string = object == null ? " " : object.toString();
                if ("".equals(string)) {
                    string = " ";
                }
                this.setText(string);
            }
            return this;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            SynthLookAndFeel.resetSelectedUI();
        }
    }
}

