/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDragGestureRecognizer;
import javax.swing.plaf.basic.BasicDropTargetListener;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.plaf.basic.DragRecognitionSupport;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicTableUI
extends TableUI {
    protected JTable table;
    protected CellRendererPane rendererPane;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    private Handler handler;
    private boolean isFileList = false;
    private static final TableDragGestureRecognizer defaultDragRecognizer = SwingUtilities2.DRAG_FIX ? null : new TableDragGestureRecognizer();
    private static DropTargetListener defaultDropTargetListener = null;
    private static final TransferHandler defaultTransferHandler = new TableTransferHandler();

    private static boolean pointOutsidePrefSize(JTable jTable, int n2, int n3, Point point) {
        if (!Boolean.TRUE.equals(jTable.getClientProperty("Table.isFileList"))) {
            return false;
        }
        return SwingUtilities2.pointOutsidePrefSize(jTable, n2, n3, point);
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = SwingUtilities2.DRAG_FIX ? new DragFixHandler() : new Handler();
        }
        return this.handler;
    }

    private DragFixHandler getDragFixHandler() {
        assert (SwingUtilities2.DRAG_FIX);
        return (DragFixHandler)this.handler;
    }

    protected KeyListener createKeyListener() {
        return null;
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return this.getHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableUI();
    }

    public void installUI(JComponent jComponent) {
        this.table = (JTable)jComponent;
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.installDefaults();
        this.installDefaults2();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        Container container;
        Color color;
        Color color2;
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        LookAndFeel.installProperty(this.table, "opaque", Boolean.TRUE);
        Color color3 = this.table.getSelectionBackground();
        if (color3 == null || color3 instanceof UIResource) {
            this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        }
        if ((color2 = this.table.getSelectionForeground()) == null || color2 instanceof UIResource) {
            this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        }
        if ((color = this.table.getGridColor()) == null || color instanceof UIResource) {
            this.table.setGridColor(UIManager.getColor("Table.gridColor"));
        }
        if ((container = this.table.getParent()) != null && (container = container.getParent()) != null && container instanceof JScrollPane) {
            LookAndFeel.installBorder((JScrollPane)container, "Table.scrollPaneBorder");
        }
        this.isFileList = Boolean.TRUE.equals(this.table.getClientProperty("Table.isFileList"));
    }

    private void installDefaults2() {
        DropTarget dropTarget;
        TransferHandler transferHandler = this.table.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.table.setTransferHandler(defaultTransferHandler);
        }
        if ((dropTarget = this.table.getDropTarget()) instanceof UIResource) {
            if (defaultDropTargetListener == null) {
                defaultDropTargetListener = new TableDropTargetListener();
            }
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        this.keyListener = this.createKeyListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.table.addFocusListener(this.focusListener);
        this.table.addKeyListener(this.keyListener);
        if (!SwingUtilities2.DRAG_FIX) {
            this.table.addMouseListener(defaultDragRecognizer);
            this.table.addMouseMotionListener(defaultDragRecognizer);
        }
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
        this.table.addPropertyChangeListener(this.getHandler());
        if (SwingUtilities2.DRAG_FIX && this.isFileList) {
            this.table.getSelectionModel().addListSelectionListener(this.getDragFixHandler());
        }
    }

    protected void installKeyboardActions() {
        LazyActionMap.installLazyActionMap(this.table, BasicTableUI.class, "Table.actionMap");
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.table, 1, inputMap);
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            InputMap inputMap = (InputMap)DefaultLookup.get(this.table, this, "Table.ancestorInputMap");
            return inputMap;
        }
        return null;
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("selectNextColumn", 1, 0, false, false));
        lazyActionMap.put(new Actions("selectNextColumnChangeLead", 1, 0, false, false));
        lazyActionMap.put(new Actions("selectPreviousColumn", -1, 0, false, false));
        lazyActionMap.put(new Actions("selectPreviousColumnChangeLead", -1, 0, false, false));
        lazyActionMap.put(new Actions("selectNextRow", 0, 1, false, false));
        lazyActionMap.put(new Actions("selectNextRowChangeLead", 0, 1, false, false));
        lazyActionMap.put(new Actions("selectPreviousRow", 0, -1, false, false));
        lazyActionMap.put(new Actions("selectPreviousRowChangeLead", 0, -1, false, false));
        lazyActionMap.put(new Actions("selectNextColumnExtendSelection", 1, 0, true, false));
        lazyActionMap.put(new Actions("selectPreviousColumnExtendSelection", -1, 0, true, false));
        lazyActionMap.put(new Actions("selectNextRowExtendSelection", 0, 1, true, false));
        lazyActionMap.put(new Actions("selectPreviousRowExtendSelection", 0, -1, true, false));
        lazyActionMap.put(new Actions("scrollUpChangeSelection", false, false, true, false));
        lazyActionMap.put(new Actions("scrollDownChangeSelection", false, true, true, false));
        lazyActionMap.put(new Actions("selectFirstColumn", false, false, false, true));
        lazyActionMap.put(new Actions("selectLastColumn", false, true, false, true));
        lazyActionMap.put(new Actions("scrollUpExtendSelection", true, false, true, false));
        lazyActionMap.put(new Actions("scrollDownExtendSelection", true, true, true, false));
        lazyActionMap.put(new Actions("selectFirstColumnExtendSelection", true, false, false, true));
        lazyActionMap.put(new Actions("selectLastColumnExtendSelection", true, true, false, true));
        lazyActionMap.put(new Actions("selectFirstRow", false, false, true, true));
        lazyActionMap.put(new Actions("selectLastRow", false, true, true, true));
        lazyActionMap.put(new Actions("selectFirstRowExtendSelection", true, false, true, true));
        lazyActionMap.put(new Actions("selectLastRowExtendSelection", true, true, true, true));
        lazyActionMap.put(new Actions("selectNextColumnCell", 1, 0, false, true));
        lazyActionMap.put(new Actions("selectPreviousColumnCell", -1, 0, false, true));
        lazyActionMap.put(new Actions("selectNextRowCell", 0, 1, false, true));
        lazyActionMap.put(new Actions("selectPreviousRowCell", 0, -1, false, true));
        lazyActionMap.put(new Actions("selectAll"));
        lazyActionMap.put(new Actions("clearSelection"));
        lazyActionMap.put(new Actions("cancel"));
        lazyActionMap.put(new Actions("startEditing"));
        lazyActionMap.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        lazyActionMap.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        lazyActionMap.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        lazyActionMap.put(new Actions("scrollLeftChangeSelection", false, false, false, false));
        lazyActionMap.put(new Actions("scrollRightChangeSelection", false, true, false, false));
        lazyActionMap.put(new Actions("scrollLeftExtendSelection", true, false, false, false));
        lazyActionMap.put(new Actions("scrollRightExtendSelection", true, true, false, false));
        lazyActionMap.put(new Actions("addToSelection"));
        lazyActionMap.put(new Actions("toggleAndAnchor"));
        lazyActionMap.put(new Actions("extendTo"));
        lazyActionMap.put(new Actions("moveSelectionTo"));
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    protected void uninstallDefaults() {
        if (this.table.getTransferHandler() instanceof UIResource) {
            this.table.setTransferHandler(null);
        }
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        if (!SwingUtilities2.DRAG_FIX) {
            this.table.removeMouseListener(defaultDragRecognizer);
            this.table.removeMouseMotionListener(defaultDragRecognizer);
        }
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.table.removePropertyChangeListener(this.getHandler());
        if (SwingUtilities2.DRAG_FIX && this.isFileList) {
            this.table.getSelectionModel().removeListSelectionListener(this.getDragFixHandler());
        }
        this.focusListener = null;
        this.keyListener = null;
        this.mouseInputListener = null;
        this.handler = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.table, 1, null);
        SwingUtilities.replaceUIActionMap(this.table, null);
    }

    private Dimension createTableSize(long l2) {
        long l3;
        int n2 = 0;
        int n3 = this.table.getRowCount();
        if (n3 > 0 && this.table.getColumnCount() > 0) {
            Rectangle rectangle = this.table.getCellRect(n3 - 1, 0, true);
            n2 = rectangle.y + rectangle.height;
        }
        if ((l3 = Math.abs(l2)) > Integer.MAX_VALUE) {
            l3 = Integer.MAX_VALUE;
        }
        return new Dimension((int)l3, n2);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        long l2 = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l2 += (long)tableColumn.getMinWidth();
        }
        return this.createTableSize(l2);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l2 = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l2 += (long)tableColumn.getPreferredWidth();
        }
        return this.createTableSize(l2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        long l2 = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l2 += (long)tableColumn.getMaxWidth();
        }
        return this.createTableSize(l2);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl2;
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = this.table.getBounds();
        rectangle2.y = 0;
        rectangle2.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !rectangle2.intersects(rectangle)) {
            return;
        }
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int n2 = this.table.rowAtPoint(point);
        int n3 = this.table.rowAtPoint(point2);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = this.table.getRowCount() - 1;
        }
        int n4 = this.table.columnAtPoint((bl2 = this.table.getComponentOrientation().isLeftToRight()) ? point : point2);
        int n5 = this.table.columnAtPoint(bl2 ? point2 : point);
        if (n4 == -1) {
            n4 = 0;
        }
        if (n5 == -1) {
            n5 = this.table.getColumnCount() - 1;
        }
        this.paintGrid(graphics, n2, n3, n4, n5);
        this.paintCells(graphics, n2, n3, n4, n5);
    }

    private void paintGrid(Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        graphics.setColor(this.table.getGridColor());
        Rectangle rectangle = this.table.getCellRect(n2, n4, true);
        Rectangle rectangle2 = this.table.getCellRect(n3, n5, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        if (this.table.getShowHorizontalLines()) {
            int n8 = rectangle3.x + rectangle3.width;
            n7 = rectangle3.y;
            for (n6 = n2; n6 <= n3; ++n6) {
                graphics.drawLine(rectangle3.x, (n7 += this.table.getRowHeight(n6)) - 1, n8 - 1, n7 - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            n7 = rectangle3.y + rectangle3.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                n6 = rectangle3.x;
                for (int i2 = n4; i2 <= n5; ++i2) {
                    int n9 = tableColumnModel.getColumn(i2).getWidth();
                    graphics.drawLine((n6 += n9) - 1, 0, n6 - 1, n7 - 1);
                }
            } else {
                n6 = rectangle3.x + rectangle3.width;
                for (int i3 = n4; i3 < n5; ++i3) {
                    int n10 = tableColumnModel.getColumn(i3).getWidth();
                    graphics.drawLine((n6 -= n10) - 1, 0, n6 - 1, n7 - 1);
                }
                graphics.drawLine(n6 -= tableColumnModel.getColumn(n5).getWidth(), 0, n6, n7 - 1);
            }
        }
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            if (tableColumnModel.getColumn(i2) != tableColumn) continue;
            return i2;
        }
        return -1;
    }

    private void paintCells(Graphics graphics, int n2, int n3, int n4, int n5) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n6 = tableColumnModel.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int i2 = n2; i2 <= n3; ++i2) {
                Rectangle rectangle = this.table.getCellRect(i2, n4, false);
                for (int i3 = n4; i3 <= n5; ++i3) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(i3);
                    int n7 = tableColumn2.getWidth();
                    rectangle.width = n7 - n6;
                    if (tableColumn2 != tableColumn) {
                        this.paintCell(graphics, rectangle, i2, i3);
                    }
                    rectangle.x += n7;
                }
            }
        } else {
            for (int i4 = n2; i4 <= n3; ++i4) {
                int n8;
                Rectangle rectangle = this.table.getCellRect(i4, n4, false);
                TableColumn tableColumn3 = tableColumnModel.getColumn(n4);
                if (tableColumn3 != tableColumn) {
                    n8 = tableColumn3.getWidth();
                    rectangle.width = n8 - n6;
                    this.paintCell(graphics, rectangle, i4, n4);
                }
                for (int i5 = n4 + 1; i5 <= n5; ++i5) {
                    tableColumn3 = tableColumnModel.getColumn(i5);
                    n8 = tableColumn3.getWidth();
                    rectangle.width = n8 - n6;
                    rectangle.x -= n8;
                    if (tableColumn3 == tableColumn) continue;
                    this.paintCell(graphics, rectangle, i4, i5);
                }
            }
        }
        if (tableColumn != null) {
            this.paintDraggedArea(graphics, n2, n3, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics graphics, int n2, int n3, TableColumn tableColumn, int n4) {
        int n5;
        int n6;
        int n7 = this.viewIndexForColumn(tableColumn);
        Rectangle rectangle = this.table.getCellRect(n2, n7, true);
        Rectangle rectangle2 = this.table.getCellRect(n3, n7, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        graphics.setColor(this.table.getParent().getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle3.x += n4;
        graphics.setColor(this.table.getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            n6 = rectangle3.x;
            int n8 = rectangle3.y;
            int n9 = n6 + rectangle3.width - 1;
            n5 = n8 + rectangle3.height - 1;
            graphics.drawLine(n6 - 1, n8, n6 - 1, n5);
            graphics.drawLine(n9, n8, n9, n5);
        }
        for (n6 = n2; n6 <= n3; ++n6) {
            Rectangle rectangle4 = this.table.getCellRect(n6, n7, false);
            rectangle4.x += n4;
            this.paintCell(graphics, rectangle4, n6, n7);
            if (!this.table.getShowHorizontalLines()) continue;
            graphics.setColor(this.table.getGridColor());
            Rectangle rectangle5 = this.table.getCellRect(n6, n7, true);
            rectangle5.x += n4;
            n5 = rectangle5.x;
            int n10 = rectangle5.y;
            int n11 = n5 + rectangle5.width - 1;
            int n12 = n10 + rectangle5.height - 1;
            graphics.drawLine(n5, n12, n11, n12);
        }
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (this.table.isEditing() && this.table.getEditingRow() == n2 && this.table.getEditingColumn() == n3) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        } else {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n2, n3);
            Component component = this.table.prepareRenderer(tableCellRenderer, n2, n3);
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }

    private static class Actions
    extends UIAction {
        private static final String CANCEL_EDITING = "cancel";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String START_EDITING = "startEditing";
        private static final String NEXT_ROW = "selectNextRow";
        private static final String NEXT_ROW_CELL = "selectNextRowCell";
        private static final String NEXT_ROW_EXTEND_SELECTION = "selectNextRowExtendSelection";
        private static final String NEXT_ROW_CHANGE_LEAD = "selectNextRowChangeLead";
        private static final String PREVIOUS_ROW = "selectPreviousRow";
        private static final String PREVIOUS_ROW_CELL = "selectPreviousRowCell";
        private static final String PREVIOUS_ROW_EXTEND_SELECTION = "selectPreviousRowExtendSelection";
        private static final String PREVIOUS_ROW_CHANGE_LEAD = "selectPreviousRowChangeLead";
        private static final String NEXT_COLUMN = "selectNextColumn";
        private static final String NEXT_COLUMN_CELL = "selectNextColumnCell";
        private static final String NEXT_COLUMN_EXTEND_SELECTION = "selectNextColumnExtendSelection";
        private static final String NEXT_COLUMN_CHANGE_LEAD = "selectNextColumnChangeLead";
        private static final String PREVIOUS_COLUMN = "selectPreviousColumn";
        private static final String PREVIOUS_COLUMN_CELL = "selectPreviousColumnCell";
        private static final String PREVIOUS_COLUMN_EXTEND_SELECTION = "selectPreviousColumnExtendSelection";
        private static final String PREVIOUS_COLUMN_CHANGE_LEAD = "selectPreviousColumnChangeLead";
        private static final String SCROLL_LEFT_CHANGE_SELECTION = "scrollLeftChangeSelection";
        private static final String SCROLL_LEFT_EXTEND_SELECTION = "scrollLeftExtendSelection";
        private static final String SCROLL_RIGHT_CHANGE_SELECTION = "scrollRightChangeSelection";
        private static final String SCROLL_RIGHT_EXTEND_SELECTION = "scrollRightExtendSelection";
        private static final String SCROLL_UP_CHANGE_SELECTION = "scrollUpChangeSelection";
        private static final String SCROLL_UP_EXTEND_SELECTION = "scrollUpExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_SELECTION = "scrollDownChangeSelection";
        private static final String SCROLL_DOWN_EXTEND_SELECTION = "scrollDownExtendSelection";
        private static final String FIRST_COLUMN = "selectFirstColumn";
        private static final String FIRST_COLUMN_EXTEND_SELECTION = "selectFirstColumnExtendSelection";
        private static final String LAST_COLUMN = "selectLastColumn";
        private static final String LAST_COLUMN_EXTEND_SELECTION = "selectLastColumnExtendSelection";
        private static final String FIRST_ROW = "selectFirstRow";
        private static final String FIRST_ROW_EXTEND_SELECTION = "selectFirstRowExtendSelection";
        private static final String LAST_ROW = "selectLastRow";
        private static final String LAST_ROW_EXTEND_SELECTION = "selectLastRowExtendSelection";
        private static final String ADD_TO_SELECTION = "addToSelection";
        private static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        private static final String EXTEND_TO = "extendTo";
        private static final String MOVE_SELECTION_TO = "moveSelectionTo";
        protected int dx;
        protected int dy;
        protected boolean extend;
        protected boolean inSelection;
        protected boolean forwards;
        protected boolean vertically;
        protected boolean toLimit;
        protected int leadRow;
        protected int leadColumn;

        Actions(String string) {
            super(string);
        }

        Actions(String string, int n2, int n3, boolean bl2, boolean bl3) {
            super(string);
            if (bl3) {
                this.inSelection = true;
                n2 = Actions.sign(n2);
                n3 = Actions.sign(n3);
                assert (!(n2 != 0 && n3 != 0 || n2 == 0 && n3 == 0));
            }
            this.dx = n2;
            this.dy = n3;
            this.extend = bl2;
        }

        Actions(String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            this(string, 0, 0, bl2, false);
            this.forwards = bl3;
            this.vertically = bl4;
            this.toLimit = bl5;
        }

        private static int clipToRange(int n2, int n3, int n4) {
            return Math.min(Math.max(n2, n3), n4 - 1);
        }

        private void moveWithinTableRange(JTable jTable, int n2, int n3) {
            this.leadRow = Actions.clipToRange(this.leadRow + n3, 0, jTable.getRowCount());
            this.leadColumn = Actions.clipToRange(this.leadColumn + n2, 0, jTable.getColumnCount());
        }

        private static int sign(int n2) {
            return n2 < 0 ? -1 : (n2 == 0 ? 0 : 1);
        }

        private boolean moveWithinSelectedRange(JTable jTable, int n2, int n3, ListSelectionModel listSelectionModel, ListSelectionModel listSelectionModel2) {
            boolean bl2;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            boolean bl3 = jTable.getRowSelectionAllowed();
            boolean bl4 = jTable.getColumnSelectionAllowed();
            if (bl3 && bl4) {
                n8 = jTable.getSelectedRowCount() * jTable.getSelectedColumnCount();
                n7 = listSelectionModel2.getMinSelectionIndex();
                n6 = listSelectionModel2.getMaxSelectionIndex();
                n5 = listSelectionModel.getMinSelectionIndex();
                n4 = listSelectionModel.getMaxSelectionIndex();
            } else if (bl3) {
                n8 = jTable.getSelectedRowCount();
                n7 = 0;
                n6 = jTable.getColumnCount() - 1;
                n5 = listSelectionModel.getMinSelectionIndex();
                n4 = listSelectionModel.getMaxSelectionIndex();
            } else if (bl4) {
                n8 = jTable.getSelectedColumnCount();
                n7 = listSelectionModel2.getMinSelectionIndex();
                n6 = listSelectionModel2.getMaxSelectionIndex();
                n5 = 0;
                n4 = jTable.getRowCount() - 1;
            } else {
                n8 = 0;
                n4 = 0;
                n5 = 0;
                n6 = 0;
                n7 = 0;
            }
            if (n8 == 0 || n8 == 1 && jTable.isCellSelected(this.leadRow, this.leadColumn)) {
                bl2 = false;
                n6 = jTable.getColumnCount() - 1;
                n4 = jTable.getRowCount() - 1;
                n7 = Math.min(0, n6);
                n5 = Math.min(0, n4);
            } else {
                bl2 = true;
            }
            this.leadRow = Math.min(Math.max(this.leadRow, n5 - 1), n4 + 1);
            this.leadColumn = Math.min(Math.max(this.leadColumn, n7 - 1), n6 + 1);
            do {
                this.calcNextPos(n2, n7, n6, n3, n5, n4);
            } while (bl2 && !jTable.isCellSelected(this.leadRow, this.leadColumn));
            return bl2;
        }

        private void calcNextPos(int n2, int n3, int n4, int n5, int n6, int n7) {
            if (n2 != 0) {
                this.leadColumn += n2;
                if (this.leadColumn > n4) {
                    this.leadColumn = n3;
                    ++this.leadRow;
                    if (this.leadRow > n7) {
                        this.leadRow = n6;
                    }
                } else if (this.leadColumn < n3) {
                    this.leadColumn = n4;
                    --this.leadRow;
                    if (this.leadRow < n6) {
                        this.leadRow = n7;
                    }
                }
            } else {
                this.leadRow += n5;
                if (this.leadRow > n7) {
                    this.leadRow = n6;
                    ++this.leadColumn;
                    if (this.leadColumn > n4) {
                        this.leadColumn = n3;
                    }
                } else if (this.leadRow < n6) {
                    this.leadRow = n7;
                    --this.leadColumn;
                    if (this.leadColumn < n3) {
                        this.leadColumn = n4;
                    }
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            String string = this.getName();
            JTable jTable = (JTable)actionEvent.getSource();
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            this.leadRow = listSelectionModel.getLeadSelectionIndex();
            ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
            this.leadColumn = listSelectionModel2.getLeadSelectionIndex();
            if (!jTable.getComponentOrientation().isLeftToRight()) {
                if (string == SCROLL_LEFT_CHANGE_SELECTION || string == SCROLL_LEFT_EXTEND_SELECTION) {
                    this.forwards = true;
                } else if (string == SCROLL_RIGHT_CHANGE_SELECTION || string == SCROLL_RIGHT_EXTEND_SELECTION) {
                    this.forwards = false;
                }
            }
            if (string == SCROLL_LEFT_CHANGE_SELECTION || string == SCROLL_LEFT_EXTEND_SELECTION || string == SCROLL_RIGHT_CHANGE_SELECTION || string == SCROLL_RIGHT_EXTEND_SELECTION || string == SCROLL_UP_CHANGE_SELECTION || string == SCROLL_UP_EXTEND_SELECTION || string == SCROLL_DOWN_CHANGE_SELECTION || string == SCROLL_DOWN_EXTEND_SELECTION || string == FIRST_COLUMN || string == FIRST_COLUMN_EXTEND_SELECTION || string == FIRST_ROW || string == FIRST_ROW_EXTEND_SELECTION || string == LAST_COLUMN || string == LAST_COLUMN_EXTEND_SELECTION || string == LAST_ROW || string == LAST_ROW_EXTEND_SELECTION) {
                if (this.toLimit) {
                    if (this.vertically) {
                        int n3 = jTable.getRowCount();
                        this.dx = 0;
                        this.dy = this.forwards ? n3 : -n3;
                    } else {
                        int n4 = jTable.getColumnCount();
                        this.dx = this.forwards ? n4 : -n4;
                        this.dy = 0;
                    }
                } else {
                    if (!(jTable.getParent().getParent() instanceof JScrollPane)) {
                        return;
                    }
                    Dimension dimension = jTable.getParent().getSize();
                    int n5 = n2 = this.vertically ? listSelectionModel.getLeadSelectionIndex() : listSelectionModel2.getLeadSelectionIndex();
                    if (this.vertically) {
                        Rectangle rectangle = jTable.getCellRect(n2, 0, true);
                        rectangle.y = rectangle.y + (this.forwards ? dimension.height : -dimension.height);
                        this.dx = 0;
                        int n6 = jTable.rowAtPoint(rectangle.getLocation());
                        if (n6 == -1 && this.forwards) {
                            n6 = jTable.getRowCount();
                        }
                        this.dy = n6 - n2;
                    } else {
                        Rectangle rectangle = jTable.getCellRect(0, n2, true);
                        rectangle.x = rectangle.x + (this.forwards ? dimension.width : -dimension.width);
                        int n7 = jTable.columnAtPoint(rectangle.getLocation());
                        if (n7 == -1 && this.forwards) {
                            n7 = jTable.getColumnCount();
                        }
                        this.dx = n7 - n2;
                        this.dy = 0;
                    }
                }
            }
            if (string == NEXT_ROW || string == NEXT_ROW_CELL || string == NEXT_ROW_EXTEND_SELECTION || string == NEXT_ROW_CHANGE_LEAD || string == NEXT_COLUMN || string == NEXT_COLUMN_CELL || string == NEXT_COLUMN_EXTEND_SELECTION || string == NEXT_COLUMN_CHANGE_LEAD || string == PREVIOUS_ROW || string == PREVIOUS_ROW_CELL || string == PREVIOUS_ROW_EXTEND_SELECTION || string == PREVIOUS_ROW_CHANGE_LEAD || string == PREVIOUS_COLUMN || string == PREVIOUS_COLUMN_CELL || string == PREVIOUS_COLUMN_EXTEND_SELECTION || string == PREVIOUS_COLUMN_CHANGE_LEAD || string == SCROLL_LEFT_CHANGE_SELECTION || string == SCROLL_LEFT_EXTEND_SELECTION || string == SCROLL_RIGHT_CHANGE_SELECTION || string == SCROLL_RIGHT_EXTEND_SELECTION || string == SCROLL_UP_CHANGE_SELECTION || string == SCROLL_UP_EXTEND_SELECTION || string == SCROLL_DOWN_CHANGE_SELECTION || string == SCROLL_DOWN_EXTEND_SELECTION || string == FIRST_COLUMN || string == FIRST_COLUMN_EXTEND_SELECTION || string == FIRST_ROW || string == FIRST_ROW_EXTEND_SELECTION || string == LAST_COLUMN || string == LAST_COLUMN_EXTEND_SELECTION || string == LAST_ROW || string == LAST_ROW_EXTEND_SELECTION) {
                if (jTable.isEditing() && !jTable.getCellEditor().stopCellEditing()) {
                    return;
                }
                boolean bl2 = false;
                if (string == NEXT_ROW_CHANGE_LEAD || string == PREVIOUS_ROW_CHANGE_LEAD) {
                    bl2 = listSelectionModel.getSelectionMode() == 2;
                } else if (string == NEXT_COLUMN_CHANGE_LEAD || string == PREVIOUS_COLUMN_CHANGE_LEAD) {
                    boolean bl3 = bl2 = listSelectionModel2.getSelectionMode() == 2;
                }
                if (bl2) {
                    this.moveWithinTableRange(jTable, this.dx, this.dy);
                    if (this.dy != 0) {
                        ((DefaultListSelectionModel)listSelectionModel).moveLeadSelectionIndex(this.leadRow);
                    } else {
                        ((DefaultListSelectionModel)listSelectionModel2).moveLeadSelectionIndex(this.leadColumn);
                    }
                    Rectangle rectangle = jTable.getCellRect(this.leadRow, this.leadColumn, false);
                    if (rectangle != null) {
                        jTable.scrollRectToVisible(rectangle);
                    }
                } else if (!this.inSelection) {
                    this.moveWithinTableRange(jTable, this.dx, this.dy);
                    jTable.changeSelection(this.leadRow, this.leadColumn, false, this.extend);
                } else if (this.moveWithinSelectedRange(jTable, this.dx, this.dy, listSelectionModel, listSelectionModel2)) {
                    if (listSelectionModel.isSelectedIndex(this.leadRow)) {
                        listSelectionModel.addSelectionInterval(this.leadRow, this.leadRow);
                    } else {
                        listSelectionModel.removeSelectionInterval(this.leadRow, this.leadRow);
                    }
                    if (listSelectionModel2.isSelectedIndex(this.leadColumn)) {
                        listSelectionModel2.addSelectionInterval(this.leadColumn, this.leadColumn);
                    } else {
                        listSelectionModel2.removeSelectionInterval(this.leadColumn, this.leadColumn);
                    }
                    Rectangle rectangle = jTable.getCellRect(this.leadRow, this.leadColumn, false);
                    if (rectangle != null) {
                        jTable.scrollRectToVisible(rectangle);
                    }
                } else {
                    jTable.changeSelection(this.leadRow, this.leadColumn, false, false);
                }
            } else if (string == CANCEL_EDITING) {
                jTable.removeEditor();
            } else if (string == SELECT_ALL) {
                jTable.selectAll();
            } else if (string == CLEAR_SELECTION) {
                jTable.clearSelection();
            } else if (string == START_EDITING) {
                if (!jTable.hasFocus()) {
                    TableCellEditor tableCellEditor = jTable.getCellEditor();
                    if (tableCellEditor != null && !tableCellEditor.stopCellEditing()) {
                        return;
                    }
                    jTable.requestFocus();
                    return;
                }
                jTable.editCellAt(this.leadRow, this.leadColumn);
                Component component = jTable.getEditorComponent();
                if (component != null) {
                    component.requestFocus();
                }
            } else if (string == ADD_TO_SELECTION) {
                if (!jTable.isCellSelected(this.leadRow, this.leadColumn)) {
                    int n8 = listSelectionModel.getAnchorSelectionIndex();
                    n2 = listSelectionModel2.getAnchorSelectionIndex();
                    listSelectionModel.setValueIsAdjusting(true);
                    listSelectionModel2.setValueIsAdjusting(true);
                    jTable.changeSelection(this.leadRow, this.leadColumn, true, false);
                    listSelectionModel.setAnchorSelectionIndex(n8);
                    listSelectionModel2.setAnchorSelectionIndex(n2);
                    listSelectionModel.setValueIsAdjusting(false);
                    listSelectionModel2.setValueIsAdjusting(false);
                }
            } else if (string == TOGGLE_AND_ANCHOR) {
                jTable.changeSelection(this.leadRow, this.leadColumn, true, false);
            } else if (string == EXTEND_TO) {
                jTable.changeSelection(this.leadRow, this.leadColumn, false, true);
            } else if (string == MOVE_SELECTION_TO) {
                jTable.changeSelection(this.leadRow, this.leadColumn, false, false);
            }
        }

        public boolean isEnabled(Object object) {
            String string = this.getName();
            if (object instanceof JTable && Boolean.TRUE.equals(((JTable)object).getClientProperty("Table.isFileList")) && (string == NEXT_COLUMN || string == NEXT_COLUMN_CELL || string == NEXT_COLUMN_EXTEND_SELECTION || string == NEXT_COLUMN_CHANGE_LEAD || string == PREVIOUS_COLUMN || string == PREVIOUS_COLUMN_CELL || string == PREVIOUS_COLUMN_EXTEND_SELECTION || string == PREVIOUS_COLUMN_CHANGE_LEAD || string == SCROLL_LEFT_CHANGE_SELECTION || string == SCROLL_LEFT_EXTEND_SELECTION || string == SCROLL_RIGHT_CHANGE_SELECTION || string == SCROLL_RIGHT_EXTEND_SELECTION || string == FIRST_COLUMN || string == FIRST_COLUMN_EXTEND_SELECTION || string == LAST_COLUMN || string == LAST_COLUMN_EXTEND_SELECTION || string == NEXT_ROW_CELL || string == PREVIOUS_ROW_CELL)) {
                return false;
            }
            if (string == CANCEL_EDITING && object instanceof JTable) {
                return ((JTable)object).isEditing();
            }
            if (string == NEXT_ROW_CHANGE_LEAD || string == PREVIOUS_ROW_CHANGE_LEAD) {
                return object != null && ((JTable)object).getSelectionModel() instanceof DefaultListSelectionModel;
            }
            if (string == NEXT_COLUMN_CHANGE_LEAD || string == PREVIOUS_COLUMN_CHANGE_LEAD) {
                return object != null && ((JTable)object).getColumnModel().getSelectionModel() instanceof DefaultListSelectionModel;
            }
            if (string == ADD_TO_SELECTION && object instanceof JTable) {
                JTable jTable = (JTable)object;
                int n2 = jTable.getSelectionModel().getLeadSelectionIndex();
                int n3 = jTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                return !jTable.isEditing() && !jTable.isCellSelected(n2, n3);
            }
            return true;
        }
    }

    private class DragFixHandler
    extends Handler
    implements ListSelectionListener,
    ActionListener,
    DragRecognitionSupport.BeforeDrag {
        private int pressedRow;
        private int pressedCol;
        private MouseEvent pressedEvent;
        private boolean dragPressDidSelection;
        private boolean dragStarted;
        private boolean shouldStartTimer;
        private boolean outsidePrefSize;
        private Timer timer;

        private DragFixHandler() {
            this.timer = null;
        }

        private boolean canStartDrag() {
            if (this.pressedRow == -1 || this.pressedCol == -1) {
                return false;
            }
            if (BasicTableUI.this.isFileList) {
                return !this.outsidePrefSize;
            }
            if (BasicTableUI.this.table.getSelectionModel().getSelectionMode() == 0 && BasicTableUI.this.table.getColumnModel().getSelectionModel().getSelectionMode() == 0) {
                return true;
            }
            return BasicTableUI.this.table.isCellSelected(this.pressedRow, this.pressedCol);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities2.shouldIgnore(mouseEvent, BasicTableUI.this.table)) {
                return;
            }
            if (BasicTableUI.this.table.isEditing() && !BasicTableUI.this.table.getCellEditor().stopCellEditing()) {
                Component component = BasicTableUI.this.table.getEditorComponent();
                if (component != null && !component.hasFocus()) {
                    BasicLookAndFeel.compositeRequestFocus(component);
                }
                return;
            }
            Point point = mouseEvent.getPoint();
            this.pressedRow = BasicTableUI.this.table.rowAtPoint(point);
            this.pressedCol = BasicTableUI.this.table.columnAtPoint(point);
            this.outsidePrefSize = BasicTableUI.pointOutsidePrefSize(BasicTableUI.this.table, this.pressedRow, this.pressedCol, point);
            if (BasicTableUI.this.isFileList) {
                boolean bl2 = this.shouldStartTimer = BasicTableUI.this.table.isCellSelected(this.pressedRow, this.pressedCol) && !mouseEvent.isShiftDown() && !mouseEvent.isControlDown() && !this.outsidePrefSize;
            }
            if (BasicTableUI.this.table.getDragEnabled()) {
                this.mousePressedDND(mouseEvent);
            } else {
                SwingUtilities2.adjustFocus(BasicTableUI.this.table);
                if (!BasicTableUI.this.isFileList) {
                    this.setValueIsAdjusting(true);
                }
                this.adjustSelection(mouseEvent);
            }
        }

        private void mousePressedDND(MouseEvent mouseEvent) {
            this.pressedEvent = mouseEvent;
            boolean bl2 = true;
            this.dragStarted = false;
            if (this.canStartDrag() && DragRecognitionSupport.mousePressed(mouseEvent)) {
                this.dragPressDidSelection = false;
                if (mouseEvent.isControlDown() && BasicTableUI.this.isFileList) {
                    return;
                }
                if (!mouseEvent.isShiftDown() && BasicTableUI.this.table.isCellSelected(this.pressedRow, this.pressedCol)) {
                    BasicTableUI.this.table.getSelectionModel().addSelectionInterval(this.pressedRow, this.pressedRow);
                    BasicTableUI.this.table.getColumnModel().getSelectionModel().addSelectionInterval(this.pressedCol, this.pressedCol);
                    return;
                }
                this.dragPressDidSelection = true;
                bl2 = false;
            } else if (!BasicTableUI.this.isFileList) {
                this.setValueIsAdjusting(true);
            }
            if (bl2) {
                SwingUtilities2.adjustFocus(BasicTableUI.this.table);
            }
            this.adjustSelection(mouseEvent);
        }

        private void adjustSelection(MouseEvent mouseEvent) {
            if (this.outsidePrefSize) {
                if (!(mouseEvent.getID() != 501 || mouseEvent.isShiftDown() && BasicTableUI.this.table.getSelectionModel().getSelectionMode() != 0)) {
                    BasicTableUI.this.table.clearSelection();
                    TableCellEditor tableCellEditor = BasicTableUI.this.table.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.stopCellEditing();
                    }
                }
                return;
            }
            if (this.pressedCol == -1 || this.pressedRow == -1) {
                return;
            }
            boolean bl2 = BasicTableUI.this.table.getDragEnabled();
            if (!bl2 && !BasicTableUI.this.isFileList && BasicTableUI.this.table.editCellAt(this.pressedRow, this.pressedCol, mouseEvent)) {
                this.setDispatchComponent(mouseEvent);
                this.repostEvent(mouseEvent);
            }
            TableCellEditor tableCellEditor = BasicTableUI.this.table.getCellEditor();
            if (bl2 || tableCellEditor == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
                this.makeSelectionChange(this.pressedRow, this.pressedCol, mouseEvent);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicTableUI.this.table.editCellAt(this.pressedRow, this.pressedCol, null);
            Component component = BasicTableUI.this.table.getEditorComponent();
            if (component != null && !component.hasFocus()) {
                BasicLookAndFeel.compositeRequestFocus(component);
            }
        }

        private void maybeStartTimer() {
            if (!this.shouldStartTimer) {
                return;
            }
            if (this.timer == null) {
                this.timer = new Timer(1200, this);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities2.shouldIgnore(mouseEvent, BasicTableUI.this.table)) {
                return;
            }
            if (BasicTableUI.this.table.getDragEnabled()) {
                this.mouseReleasedDND(mouseEvent);
            } else if (BasicTableUI.this.isFileList) {
                this.maybeStartTimer();
            }
            this.pressedEvent = null;
            this.repostEvent(mouseEvent);
            this.dispatchComponent = null;
            this.setValueIsAdjusting(false);
        }

        private void mouseReleasedDND(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = DragRecognitionSupport.mouseReleased(mouseEvent);
            if (mouseEvent2 != null) {
                SwingUtilities2.adjustFocus(BasicTableUI.this.table);
                if (!this.dragPressDidSelection) {
                    this.adjustSelection(mouseEvent2);
                }
            }
            if (!this.dragStarted) {
                if (BasicTableUI.this.isFileList) {
                    this.maybeStartTimer();
                    return;
                }
                Point point = mouseEvent.getPoint();
                if (this.pressedEvent != null && BasicTableUI.this.table.rowAtPoint(point) == this.pressedRow && BasicTableUI.this.table.columnAtPoint(point) == this.pressedCol && BasicTableUI.this.table.editCellAt(this.pressedRow, this.pressedCol, this.pressedEvent)) {
                    this.setDispatchComponent(this.pressedEvent);
                    this.repostEvent(this.pressedEvent);
                    TableCellEditor tableCellEditor = BasicTableUI.this.table.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.shouldSelectCell(this.pressedEvent);
                    }
                }
            }
        }

        public void dragStarting(MouseEvent mouseEvent) {
            this.dragStarted = true;
            if (mouseEvent.isControlDown() && BasicTableUI.this.isFileList) {
                BasicTableUI.this.table.getSelectionModel().addSelectionInterval(this.pressedRow, this.pressedRow);
                BasicTableUI.this.table.getColumnModel().getSelectionModel().addSelectionInterval(this.pressedCol, this.pressedCol);
            }
            this.pressedEvent = null;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities2.shouldIgnore(mouseEvent, BasicTableUI.this.table)) {
                return;
            }
            if (BasicTableUI.this.table.getDragEnabled() && (DragRecognitionSupport.mouseDragged(mouseEvent, this) || this.dragStarted)) {
                return;
            }
            this.mouseDraggedImpl(mouseEvent);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if ("Table.isFileList" == string) {
                if (BasicTableUI.this.isFileList) {
                    BasicTableUI.this.table.getSelectionModel().addListSelectionListener(BasicTableUI.this.getDragFixHandler());
                } else {
                    BasicTableUI.this.table.getSelectionModel().removeListSelectionListener(BasicTableUI.this.getDragFixHandler());
                    this.timer = null;
                }
            } else if ("selectionModel" == string && BasicTableUI.this.isFileList) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                listSelectionModel.removeListSelectionListener(BasicTableUI.this.getDragFixHandler());
                BasicTableUI.this.table.getSelectionModel().addListSelectionListener(BasicTableUI.this.getDragFixHandler());
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            BasicTableUI.this.getHandler().focusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            BasicTableUI.this.getHandler().focusLost(focusEvent);
        }
    }

    private class Handler
    implements FocusListener,
    MouseInputListener,
    PropertyChangeListener {
        protected Component dispatchComponent;
        private boolean selectedOnPress;

        private Handler() {
        }

        private void repaintLeadCell() {
            int n2 = BasicTableUI.this.table.getRowCount();
            int n3 = BasicTableUI.this.table.getColumnCount();
            int n4 = BasicTableUI.this.table.getSelectionModel().getLeadSelectionIndex();
            int n5 = BasicTableUI.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (n4 < 0 || n4 >= n2 || n5 < 0 || n5 >= n3) {
                return;
            }
            Rectangle rectangle = BasicTableUI.this.table.getCellRect(n4, n5, false);
            BasicTableUI.this.table.repaint(rectangle);
        }

        public void focusGained(FocusEvent focusEvent) {
            this.repaintLeadCell();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintLeadCell();
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke((int)keyEvent.getKeyChar(), keyEvent.getModifiers());
            InputMap inputMap = BasicTableUI.this.table.getInputMap(0);
            if (inputMap != null && inputMap.get(keyStroke) != null) {
                return;
            }
            inputMap = BasicTableUI.this.table.getInputMap(1);
            if (inputMap != null && inputMap.get(keyStroke) != null) {
                return;
            }
            keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            if (keyEvent.getKeyChar() == '\r') {
                return;
            }
            int n2 = BasicTableUI.this.table.getSelectionModel().getLeadSelectionIndex();
            int n3 = BasicTableUI.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (n2 != -1 && n3 != -1 && !BasicTableUI.this.table.isEditing() && !BasicTableUI.this.table.editCellAt(n2, n3)) {
                return;
            }
            Component component = BasicTableUI.this.table.getEditorComponent();
            if (BasicTableUI.this.table.isEditing() && component != null && component instanceof JComponent) {
                Object object;
                JComponent jComponent = (JComponent)component;
                inputMap = jComponent.getInputMap(0);
                Object object2 = object = inputMap != null ? inputMap.get(keyStroke) : null;
                if (object == null) {
                    inputMap = jComponent.getInputMap(1);
                    Object object3 = object = inputMap != null ? inputMap.get(keyStroke) : null;
                }
                if (object != null) {
                    Action action;
                    ActionMap actionMap = jComponent.getActionMap();
                    Action action2 = action = actionMap != null ? actionMap.get(object) : null;
                    if (action != null && SwingUtilities.notifyAction(action, keyStroke, keyEvent, jComponent, keyEvent.getModifiers())) {
                        keyEvent.consume();
                    }
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        protected void setDispatchComponent(MouseEvent mouseEvent) {
            Component component = BasicTableUI.this.table.getEditorComponent();
            Point point = mouseEvent.getPoint();
            Point point2 = SwingUtilities.convertPoint(BasicTableUI.this.table, point, component);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
        }

        protected boolean repostEvent(MouseEvent mouseEvent) {
            if (this.dispatchComponent == null || !BasicTableUI.this.table.isEditing()) {
                return false;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(BasicTableUI.this.table, mouseEvent, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(mouseEvent2);
            return true;
        }

        protected void setValueIsAdjusting(boolean bl2) {
            BasicTableUI.this.table.getSelectionModel().setValueIsAdjusting(bl2);
            BasicTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(bl2);
        }

        private boolean shouldIgnore0(MouseEvent mouseEvent) {
            return mouseEvent.isConsumed() || SwingUtilities2.shouldIgnore(mouseEvent, BasicTableUI.this.table);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.adjustFocusAndSelection(mouseEvent);
        }

        void adjustFocusAndSelection(MouseEvent mouseEvent) {
            int n2;
            if (this.shouldIgnore0(mouseEvent)) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n3 = BasicTableUI.this.table.rowAtPoint(point);
            if (BasicTableUI.pointOutsidePrefSize(BasicTableUI.this.table, n3, n2 = BasicTableUI.this.table.columnAtPoint(point), point)) {
                if (!(mouseEvent.getID() != 501 || mouseEvent.isShiftDown() && BasicTableUI.this.table.getSelectionModel().getSelectionMode() != 0)) {
                    BasicTableUI.this.table.clearSelection();
                    TableCellEditor tableCellEditor = BasicTableUI.this.table.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.stopCellEditing();
                    }
                }
                return;
            }
            if (n2 == -1 || n3 == -1) {
                return;
            }
            if (BasicTableUI.this.table.editCellAt(n3, n2, mouseEvent)) {
                this.setDispatchComponent(mouseEvent);
                this.repostEvent(mouseEvent);
            } else {
                SwingUtilities2.adjustFocus(BasicTableUI.this.table);
            }
            TableCellEditor tableCellEditor = BasicTableUI.this.table.getCellEditor();
            if (tableCellEditor == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
                boolean bl2 = mouseEvent.getID() == 501;
                this.setValueIsAdjusting(bl2);
                this.makeSelectionChange(n3, n2, mouseEvent);
            }
        }

        protected void makeSelectionChange(int n2, int n3, MouseEvent mouseEvent) {
            boolean bl2 = mouseEvent.isControlDown();
            if (bl2 && mouseEvent.isShiftDown()) {
                int n4;
                ListSelectionModel listSelectionModel = BasicTableUI.this.table.getSelectionModel();
                ListSelectionModel listSelectionModel2 = BasicTableUI.this.table.getColumnModel().getSelectionModel();
                int n5 = listSelectionModel.getAnchorSelectionIndex();
                if (BasicTableUI.this.table.isCellSelected(n5, n4 = listSelectionModel2.getAnchorSelectionIndex())) {
                    listSelectionModel.addSelectionInterval(n5, n2);
                    listSelectionModel2.addSelectionInterval(n4, n3);
                } else {
                    listSelectionModel.removeSelectionInterval(n5, n2);
                    listSelectionModel.addSelectionInterval(n2, n2);
                    listSelectionModel.setAnchorSelectionIndex(n5);
                    listSelectionModel2.removeSelectionInterval(n4, n3);
                    listSelectionModel2.addSelectionInterval(n3, n3);
                    listSelectionModel2.setAnchorSelectionIndex(n4);
                }
            } else {
                BasicTableUI.this.table.changeSelection(n2, n3, bl2, !bl2 && mouseEvent.isShiftDown());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.selectedOnPress) {
                if (this.shouldIgnore0(mouseEvent)) {
                    return;
                }
                this.repostEvent(mouseEvent);
                this.dispatchComponent = null;
                this.setValueIsAdjusting(false);
            } else {
                this.adjustFocusAndSelection(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.shouldIgnore0(mouseEvent)) {
                return;
            }
            this.mouseDraggedImpl(mouseEvent);
        }

        protected void mouseDraggedImpl(MouseEvent mouseEvent) {
            this.repostEvent(mouseEvent);
            if (BasicTableUI.this.isFileList || BasicTableUI.this.table.getCellEditor() != null) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n2 = BasicTableUI.this.table.rowAtPoint(point);
            int n3 = BasicTableUI.this.table.columnAtPoint(point);
            if (n3 == -1 || n2 == -1) {
                return;
            }
            BasicTableUI.this.table.changeSelection(n2, n3, false, true);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("componentOrientation" == string) {
                JTableHeader jTableHeader = BasicTableUI.this.table.getTableHeader();
                if (jTableHeader != null) {
                    jTableHeader.setComponentOrientation((ComponentOrientation)propertyChangeEvent.getNewValue());
                }
            } else if ("transferHandler" == string) {
                DropTarget dropTarget = BasicTableUI.this.table.getDropTarget();
                if (dropTarget instanceof UIResource) {
                    if (defaultDropTargetListener == null) {
                        defaultDropTargetListener = new TableDropTargetListener();
                    }
                    try {
                        dropTarget.addDropTargetListener(defaultDropTargetListener);
                    }
                    catch (TooManyListenersException tooManyListenersException) {}
                }
            } else if ("Table.isFileList" == string) {
                BasicTableUI.this.isFileList = Boolean.TRUE.equals(BasicTableUI.this.table.getClientProperty("Table.isFileList"));
                BasicTableUI.this.table.revalidate();
                BasicTableUI.this.table.repaint();
            }
        }
    }

    public class KeyHandler
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
            BasicTableUI.this.getHandler().keyPressed(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            BasicTableUI.this.getHandler().keyReleased(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            BasicTableUI.this.getHandler().keyTyped(keyEvent);
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        public void mouseClicked(MouseEvent mouseEvent) {
            BasicTableUI.this.getHandler().mouseClicked(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BasicTableUI.this.getHandler().mousePressed(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicTableUI.this.getHandler().mouseReleased(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            BasicTableUI.this.getHandler().mouseEntered(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BasicTableUI.this.getHandler().mouseExited(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            BasicTableUI.this.getHandler().mouseMoved(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            BasicTableUI.this.getHandler().mouseDragged(mouseEvent);
        }
    }

    static class TableDragGestureRecognizer
    extends BasicDragGestureRecognizer {
        TableDragGestureRecognizer() {
        }

        protected boolean isDragPossible(MouseEvent mouseEvent) {
            JTable jTable;
            if (super.isDragPossible(mouseEvent) && (jTable = (JTable)this.getComponent(mouseEvent)).getDragEnabled()) {
                int n2;
                Point point = mouseEvent.getPoint();
                int n3 = jTable.rowAtPoint(point);
                if (BasicTableUI.pointOutsidePrefSize(jTable, n3, n2 = jTable.columnAtPoint(point), point)) {
                    return false;
                }
                if (n2 != -1 && n3 != -1 && jTable.isCellSelected(n3, n2)) {
                    return true;
                }
            }
            return false;
        }
    }

    static class TableDropTargetListener
    extends BasicDropTargetListener {
        private int[] rows;
        private int[] cols;

        TableDropTargetListener() {
        }

        protected void saveComponentState(JComponent jComponent) {
            JTable jTable = (JTable)jComponent;
            this.rows = jTable.getSelectedRows();
            this.cols = jTable.getSelectedColumns();
        }

        protected void restoreComponentState(JComponent jComponent) {
            int n2;
            JTable jTable = (JTable)jComponent;
            jTable.clearSelection();
            for (n2 = 0; n2 < this.rows.length; ++n2) {
                jTable.addRowSelectionInterval(this.rows[n2], this.rows[n2]);
            }
            for (n2 = 0; n2 < this.cols.length; ++n2) {
                jTable.addColumnSelectionInterval(this.cols[n2], this.cols[n2]);
            }
        }

        protected void updateInsertionLocation(JComponent jComponent, Point point) {
            JTable jTable = (JTable)jComponent;
            int n2 = jTable.rowAtPoint(point);
            int n3 = jTable.columnAtPoint(point);
            if (n2 != -1) {
                jTable.setRowSelectionInterval(n2, n2);
            }
            if (n3 != -1) {
                jTable.setColumnSelectionInterval(n3, n3);
            }
        }
    }

    static class TableTransferHandler
    extends TransferHandler
    implements UIResource {
        TableTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JTable) {
                int[] nArray;
                int n2;
                int[] nArray2;
                int n3;
                JTable jTable = (JTable)jComponent;
                if (!jTable.getRowSelectionAllowed() && !jTable.getColumnSelectionAllowed()) {
                    return null;
                }
                if (!jTable.getRowSelectionAllowed()) {
                    n3 = jTable.getRowCount();
                    nArray2 = new int[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        nArray2[n2] = n2;
                    }
                } else {
                    nArray2 = jTable.getSelectedRows();
                }
                if (!jTable.getColumnSelectionAllowed()) {
                    n3 = jTable.getColumnCount();
                    nArray = new int[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        nArray[n2] = n2;
                    }
                } else {
                    nArray = jTable.getSelectedColumns();
                }
                if (nArray2 == null || nArray == null || nArray2.length == 0 || nArray.length == 0) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<html>\n<body>\n<table>\n");
                for (int i2 = 0; i2 < nArray2.length; ++i2) {
                    stringBuffer2.append("<tr>\n");
                    for (int i3 = 0; i3 < nArray.length; ++i3) {
                        Object object = jTable.getValueAt(nArray2[i2], nArray[i3]);
                        String string = object == null ? "" : object.toString();
                        stringBuffer.append(string + "\t");
                        stringBuffer2.append("  <td>" + string + "</td>\n");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1).append("\n");
                    stringBuffer2.append("</tr>\n");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer2.append("</table>\n</body>\n</html>");
                return new BasicTransferable(stringBuffer.toString(), stringBuffer2.toString());
            }
            return null;
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }
    }
}

