/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;

public class MBeanConstructorInfo
extends MBeanFeatureInfo
implements Serializable,
Cloneable {
    static final long serialVersionUID = 4433990064191844427L;
    static final MBeanConstructorInfo[] NO_CONSTRUCTORS = new MBeanConstructorInfo[0];
    private final transient boolean immutable;
    private final MBeanParameterInfo[] signature;

    public MBeanConstructorInfo(String string, Constructor constructor) {
        this(constructor.getName(), string, MBeanConstructorInfo.constructorSignature(constructor));
    }

    public MBeanConstructorInfo(String string, String string2, MBeanParameterInfo[] mBeanParameterInfoArray) throws IllegalArgumentException {
        super(string, string2);
        mBeanParameterInfoArray = mBeanParameterInfoArray == null || mBeanParameterInfoArray.length == 0 ? MBeanParameterInfo.NO_PARAMS : (MBeanParameterInfo[])mBeanParameterInfoArray.clone();
        this.signature = mBeanParameterInfoArray;
        this.immutable = MBeanInfo.isImmutableClass(this.getClass(), MBeanConstructorInfo.class);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public MBeanParameterInfo[] getSignature() {
        if (this.signature.length == 0) {
            return this.signature;
        }
        return (MBeanParameterInfo[])this.signature.clone();
    }

    private MBeanParameterInfo[] fastGetSignature() {
        if (this.immutable) {
            return this.signature;
        }
        return this.getSignature();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MBeanConstructorInfo)) {
            return false;
        }
        MBeanConstructorInfo mBeanConstructorInfo = (MBeanConstructorInfo)object;
        return mBeanConstructorInfo.getName().equals(this.getName()) && mBeanConstructorInfo.getDescription().equals(this.getDescription()) && Arrays.equals(mBeanConstructorInfo.fastGetSignature(), this.fastGetSignature());
    }

    public int hashCode() {
        int n2 = this.getName().hashCode();
        MBeanParameterInfo[] mBeanParameterInfoArray = this.fastGetSignature();
        for (int i2 = 0; i2 < mBeanParameterInfoArray.length; ++i2) {
            n2 ^= mBeanParameterInfoArray[i2].hashCode();
        }
        return n2;
    }

    private static MBeanParameterInfo[] constructorSignature(Constructor constructor) {
        Class<?>[] classArray = constructor.getParameterTypes();
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[classArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            String string = "p" + (i2 + 1);
            mBeanParameterInfoArray[i2] = new MBeanParameterInfo(string, classArray[i2].getName(), "");
        }
        return mBeanParameterInfoArray;
    }
}

