/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl;

import com.sun.org.apache.xerces.internal.util.DefaultErrorHandler;
import com.sun.org.apache.xerces.internal.util.ErrorHandlerProxy;
import com.sun.org.apache.xerces.internal.util.MessageFormatter;
import com.sun.org.apache.xerces.internal.xni.XMLLocator;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponent;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLErrorHandler;
import com.sun.org.apache.xerces.internal.xni.parser.XMLParseException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import org.xml.sax.ErrorHandler;

public class XMLErrorReporter
implements XMLComponent {
    public static final short SEVERITY_WARNING = 0;
    public static final short SEVERITY_ERROR = 1;
    public static final short SEVERITY_FATAL_ERROR = 2;
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/features/continue-after-fatal-error"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{null};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/error-handler"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null};
    protected Locale fLocale;
    protected Hashtable fMessageFormatters = new Hashtable();
    protected XMLErrorHandler fErrorHandler;
    protected XMLLocator fLocator;
    protected boolean fContinueAfterFatalError;
    protected XMLErrorHandler fDefaultErrorHandler;
    private ErrorHandler fSaxProxy = null;

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public void setDocumentLocator(XMLLocator xMLLocator) {
        this.fLocator = xMLLocator;
    }

    public void putMessageFormatter(String string, MessageFormatter messageFormatter) {
        this.fMessageFormatters.put(string, messageFormatter);
    }

    public MessageFormatter getMessageFormatter(String string) {
        return (MessageFormatter)this.fMessageFormatters.get(string);
    }

    public MessageFormatter removeMessageFormatter(String string) {
        return (MessageFormatter)this.fMessageFormatters.remove(string);
    }

    public void reportError(String string, String string2, Object[] objectArray, short s2) throws XNIException {
        this.reportError(this.fLocator, string, string2, objectArray, s2);
    }

    public void reportError(XMLLocator xMLLocator, String string, String string2, Object[] objectArray, short s2) throws XNIException {
        Serializable serializable;
        String string3;
        MessageFormatter messageFormatter = this.getMessageFormatter(string);
        if (messageFormatter != null) {
            string3 = messageFormatter.formatMessage(this.fLocale, string2, objectArray);
        } else {
            int n2;
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append('#');
            ((StringBuffer)serializable).append(string2);
            int n3 = n2 = objectArray != null ? objectArray.length : 0;
            if (n2 > 0) {
                ((StringBuffer)serializable).append('?');
                for (int i2 = 0; i2 < n2; ++i2) {
                    ((StringBuffer)serializable).append(objectArray[i2]);
                    if (i2 >= n2 - 1) continue;
                    ((StringBuffer)serializable).append('&');
                }
            }
            string3 = ((StringBuffer)serializable).toString();
        }
        serializable = new XMLParseException(xMLLocator, string3);
        XMLErrorHandler xMLErrorHandler = this.fErrorHandler;
        if (xMLErrorHandler == null) {
            if (this.fDefaultErrorHandler == null) {
                this.fDefaultErrorHandler = new DefaultErrorHandler();
            }
            xMLErrorHandler = this.fDefaultErrorHandler;
        }
        switch (s2) {
            case 0: {
                xMLErrorHandler.warning(string, string2, (XMLParseException)serializable);
                break;
            }
            case 1: {
                xMLErrorHandler.error(string, string2, (XMLParseException)serializable);
                break;
            }
            case 2: {
                xMLErrorHandler.fatalError(string, string2, (XMLParseException)serializable);
                if (this.fContinueAfterFatalError) break;
                throw serializable;
            }
        }
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XNIException {
        try {
            this.fContinueAfterFatalError = xMLComponentManager.getFeature(CONTINUE_AFTER_FATAL_ERROR);
        }
        catch (XNIException xNIException) {
            this.fContinueAfterFatalError = false;
        }
        this.fErrorHandler = (XMLErrorHandler)xMLComponentManager.getProperty(ERROR_HANDLER);
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public void setFeature(String string, boolean bl2) throws XMLConfigurationException {
        int n2;
        if (string.startsWith("http://apache.org/xml/features/") && (n2 = string.length() - "http://apache.org/xml/features/".length()) == "continue-after-fatal-error".length() && string.endsWith("continue-after-fatal-error")) {
            this.fContinueAfterFatalError = bl2;
        }
    }

    public boolean getFeature(String string) throws XMLConfigurationException {
        int n2;
        if (string.startsWith("http://apache.org/xml/features/") && (n2 = string.length() - "http://apache.org/xml/features/".length()) == "continue-after-fatal-error".length() && string.endsWith("continue-after-fatal-error")) {
            return this.fContinueAfterFatalError;
        }
        return false;
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        int n2;
        if (string.startsWith("http://apache.org/xml/properties/") && (n2 = string.length() - "http://apache.org/xml/properties/".length()) == "internal/error-handler".length() && string.endsWith("internal/error-handler")) {
            this.fErrorHandler = (XMLErrorHandler)object;
        }
    }

    public Boolean getFeatureDefault(String string) {
        for (int i2 = 0; i2 < RECOGNIZED_FEATURES.length; ++i2) {
            if (!RECOGNIZED_FEATURES[i2].equals(string)) continue;
            return FEATURE_DEFAULTS[i2];
        }
        return null;
    }

    public Object getPropertyDefault(String string) {
        for (int i2 = 0; i2 < RECOGNIZED_PROPERTIES.length; ++i2) {
            if (!RECOGNIZED_PROPERTIES[i2].equals(string)) continue;
            return PROPERTY_DEFAULTS[i2];
        }
        return null;
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public ErrorHandler getSAXErrorHandler() {
        if (this.fSaxProxy == null) {
            this.fSaxProxy = new ErrorHandlerProxy(){

                protected XMLErrorHandler getErrorHandler() {
                    return XMLErrorReporter.this.fErrorHandler;
                }
            };
        }
        return this.fSaxProxy;
    }
}

