/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.BottomMarginRecord;
import org.apache.poi.hssf.record.FooterRecord;
import org.apache.poi.hssf.record.HCenterRecord;
import org.apache.poi.hssf.record.HeaderRecord;
import org.apache.poi.hssf.record.HorizontalPageBreakRecord;
import org.apache.poi.hssf.record.LeftMarginRecord;
import org.apache.poi.hssf.record.Margin;
import org.apache.poi.hssf.record.PageBreakRecord;
import org.apache.poi.hssf.record.PrintSetupRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RightMarginRecord;
import org.apache.poi.hssf.record.TopMarginRecord;
import org.apache.poi.hssf.record.VCenterRecord;
import org.apache.poi.hssf.record.VerticalPageBreakRecord;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;

public final class PageSettingsBlock
extends RecordAggregate {
    private PageBreakRecord _rowBreaksRecord;
    private PageBreakRecord _columnBreaksRecord;
    private HeaderRecord header;
    private FooterRecord footer;
    private HCenterRecord _hCenter;
    private VCenterRecord _vCenter;
    private LeftMarginRecord _leftMargin;
    private RightMarginRecord _rightMargin;
    private TopMarginRecord _topMargin;
    private BottomMarginRecord _bottomMargin;
    private Record _pls;
    private PrintSetupRecord printSetup;
    private Record _bitmap;

    public PageSettingsBlock(RecordStream rs) {
        while (this.readARecord(rs)) {
        }
    }

    public PageSettingsBlock() {
        this._rowBreaksRecord = new HorizontalPageBreakRecord();
        this._columnBreaksRecord = new VerticalPageBreakRecord();
        this.header = PageSettingsBlock.createHeader();
        this.footer = PageSettingsBlock.createFooter();
        this._hCenter = PageSettingsBlock.createHCenter();
        this._vCenter = PageSettingsBlock.createVCenter();
        this.printSetup = PageSettingsBlock.createPrintSetup();
    }

    public static boolean isComponentRecord(int sid) {
        switch (sid) {
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 77: 
            case 131: 
            case 132: 
            case 161: 
            case 233: {
                return true;
            }
        }
        return false;
    }

    private boolean readARecord(RecordStream rs) {
        switch (rs.peekNextSid()) {
            case 27: {
                this._rowBreaksRecord = (PageBreakRecord)rs.getNext();
                break;
            }
            case 26: {
                this._columnBreaksRecord = (PageBreakRecord)rs.getNext();
                break;
            }
            case 20: {
                this.header = (HeaderRecord)rs.getNext();
                break;
            }
            case 21: {
                this.footer = (FooterRecord)rs.getNext();
                break;
            }
            case 131: {
                this._hCenter = (HCenterRecord)rs.getNext();
                break;
            }
            case 132: {
                this._vCenter = (VCenterRecord)rs.getNext();
                break;
            }
            case 38: {
                this._leftMargin = (LeftMarginRecord)rs.getNext();
                break;
            }
            case 39: {
                this._rightMargin = (RightMarginRecord)rs.getNext();
                break;
            }
            case 40: {
                this._topMargin = (TopMarginRecord)rs.getNext();
                break;
            }
            case 41: {
                this._bottomMargin = (BottomMarginRecord)rs.getNext();
                break;
            }
            case 77: {
                this._pls = rs.getNext();
                break;
            }
            case 161: {
                this.printSetup = (PrintSetupRecord)rs.getNext();
                break;
            }
            case 233: {
                this._bitmap = rs.getNext();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private PageBreakRecord getRowBreaksRecord() {
        if (this._rowBreaksRecord == null) {
            this._rowBreaksRecord = new HorizontalPageBreakRecord();
        }
        return this._rowBreaksRecord;
    }

    private PageBreakRecord getColumnBreaksRecord() {
        if (this._columnBreaksRecord == null) {
            this._columnBreaksRecord = new VerticalPageBreakRecord();
        }
        return this._columnBreaksRecord;
    }

    public void setColumnBreak(short column, short fromRow, short toRow) {
        this.getColumnBreaksRecord().addBreak(column, fromRow, toRow);
    }

    public void removeColumnBreak(int column) {
        this.getColumnBreaksRecord().removeBreak(column);
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor rv) {
        PageSettingsBlock.visitIfPresent(this._rowBreaksRecord, rv);
        PageSettingsBlock.visitIfPresent(this._columnBreaksRecord, rv);
        PageSettingsBlock.visitIfPresent(this.header, rv);
        PageSettingsBlock.visitIfPresent(this.footer, rv);
        PageSettingsBlock.visitIfPresent(this._hCenter, rv);
        PageSettingsBlock.visitIfPresent(this._vCenter, rv);
        PageSettingsBlock.visitIfPresent(this._leftMargin, rv);
        PageSettingsBlock.visitIfPresent(this._rightMargin, rv);
        PageSettingsBlock.visitIfPresent(this._topMargin, rv);
        PageSettingsBlock.visitIfPresent(this._bottomMargin, rv);
        PageSettingsBlock.visitIfPresent(this._pls, rv);
        PageSettingsBlock.visitIfPresent(this.printSetup, rv);
        PageSettingsBlock.visitIfPresent(this._bitmap, rv);
    }

    private static void visitIfPresent(Record r, RecordAggregate.RecordVisitor rv) {
        if (r != null) {
            rv.visitRecord(r);
        }
    }

    private static HeaderRecord createHeader() {
        HeaderRecord retval = new HeaderRecord();
        retval.setHeaderLength((byte)0);
        retval.setHeader(null);
        return retval;
    }

    private static FooterRecord createFooter() {
        FooterRecord retval = new FooterRecord();
        retval.setFooterLength((byte)0);
        retval.setFooter(null);
        return retval;
    }

    private static HCenterRecord createHCenter() {
        HCenterRecord retval = new HCenterRecord();
        retval.setHCenter(false);
        return retval;
    }

    private static VCenterRecord createVCenter() {
        VCenterRecord retval = new VCenterRecord();
        retval.setVCenter(false);
        return retval;
    }

    private static PrintSetupRecord createPrintSetup() {
        PrintSetupRecord retval = new PrintSetupRecord();
        retval.setPaperSize((short)1);
        retval.setScale((short)100);
        retval.setPageStart((short)1);
        retval.setFitWidth((short)1);
        retval.setFitHeight((short)1);
        retval.setOptions((short)2);
        retval.setHResolution((short)300);
        retval.setVResolution((short)300);
        retval.setHeaderMargin(0.5);
        retval.setFooterMargin(0.5);
        retval.setCopies((short)0);
        return retval;
    }

    public HeaderRecord getHeader() {
        return this.header;
    }

    public void setHeader(HeaderRecord newHeader) {
        this.header = newHeader;
    }

    public FooterRecord getFooter() {
        return this.footer;
    }

    public void setFooter(FooterRecord newFooter) {
        this.footer = newFooter;
    }

    public PrintSetupRecord getPrintSetup() {
        return this.printSetup;
    }

    public void setPrintSetup(PrintSetupRecord newPrintSetup) {
        this.printSetup = newPrintSetup;
    }

    private Margin getMarginRec(int marginIndex) {
        switch (marginIndex) {
            case 0: {
                return this._leftMargin;
            }
            case 1: {
                return this._rightMargin;
            }
            case 2: {
                return this._topMargin;
            }
            case 3: {
                return this._bottomMargin;
            }
        }
        throw new RuntimeException("Unknown margin constant:  " + marginIndex);
    }

    public double getMargin(short margin) {
        Margin m = this.getMarginRec(margin);
        if (m != null) {
            return m.getMargin();
        }
        switch (margin) {
            case 0: {
                return 0.75;
            }
            case 1: {
                return 0.75;
            }
            case 2: {
                return 1.0;
            }
            case 3: {
                return 1.0;
            }
        }
        throw new RuntimeException("Unknown margin constant:  " + margin);
    }

    public void setMargin(short margin, double size) {
        Margin m = this.getMarginRec(margin);
        if (m == null) {
            switch (margin) {
                case 0: {
                    this._leftMargin = new LeftMarginRecord();
                    m = this._leftMargin;
                    break;
                }
                case 1: {
                    this._rightMargin = new RightMarginRecord();
                    m = this._rightMargin;
                    break;
                }
                case 2: {
                    this._topMargin = new TopMarginRecord();
                    m = this._topMargin;
                    break;
                }
                case 3: {
                    this._bottomMargin = new BottomMarginRecord();
                    m = this._bottomMargin;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown margin constant:  " + margin);
                }
            }
        }
        m.setMargin(size);
    }

    private static void shiftBreaks(PageBreakRecord breaks, int start, int stop, int count) {
        PageBreakRecord.Break breakItem;
        Iterator iterator = breaks.getBreaksIterator();
        ArrayList<PageBreakRecord.Break> shiftedBreak = new ArrayList<PageBreakRecord.Break>();
        while (iterator.hasNext()) {
            boolean inEnd;
            breakItem = (PageBreakRecord.Break)iterator.next();
            int breakLocation = breakItem.main;
            boolean inStart = breakLocation >= start;
            boolean bl = inEnd = breakLocation <= stop;
            if (!inStart || !inEnd) continue;
            shiftedBreak.add(breakItem);
        }
        iterator = shiftedBreak.iterator();
        while (iterator.hasNext()) {
            breakItem = (PageBreakRecord.Break)iterator.next();
            breaks.removeBreak(breakItem.main);
            breaks.addBreak((short)(breakItem.main + count), breakItem.subFrom, breakItem.subTo);
        }
    }

    public void setRowBreak(int row, short fromCol, short toCol) {
        this.getRowBreaksRecord().addBreak((short)row, fromCol, toCol);
    }

    public void removeRowBreak(int row) {
        if (this.getRowBreaksRecord().getBreaks().length < 1) {
            throw new IllegalArgumentException("Sheet does not define any row breaks");
        }
        this.getRowBreaksRecord().removeBreak((short)row);
    }

    public boolean isRowBroken(int row) {
        return this.getRowBreaksRecord().getBreak(row) != null;
    }

    public boolean isColumnBroken(int column) {
        return this.getColumnBreaksRecord().getBreak(column) != null;
    }

    public void shiftRowBreaks(int startingRow, int endingRow, int count) {
        PageSettingsBlock.shiftBreaks(this.getRowBreaksRecord(), startingRow, endingRow, count);
    }

    public void shiftColumnBreaks(short startingCol, short endingCol, short count) {
        PageSettingsBlock.shiftBreaks(this.getColumnBreaksRecord(), startingCol, endingCol, count);
    }

    public int[] getRowBreaks() {
        return this.getRowBreaksRecord().getBreaks();
    }

    public int getNumRowBreaks() {
        return this.getRowBreaksRecord().getNumBreaks();
    }

    public int[] getColumnBreaks() {
        return this.getColumnBreaksRecord().getBreaks();
    }

    public int getNumColumnBreaks() {
        return this.getColumnBreaksRecord().getNumBreaks();
    }

    public VCenterRecord getVCenter() {
        return this._vCenter;
    }

    public HCenterRecord getHCenter() {
        return this._hCenter;
    }
}

