/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.util;

import com.sbs.jpm.Common;
import com.sbs.jpm.ui.JApplication;
import edu.stanford.ejalbert.BrowserLauncher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;

public final class SystemUtilities {
    private static boolean isLibraryLoaded;
    private static boolean isWindows;
    private static boolean isWindowsXP;
    private static boolean isWindows2000;
    private static boolean isWindowsVista;
    private static boolean isMac;
    private static boolean isLinux;
    private static File USER_HOME_DIRECTORY;
    private static File USER_DEFAULT_DIRECTORY;
    private static File USER_SETTINGS_DIRECTORY;
    private static File USER_DATA_DIRECTORY;
    private static File USER_LOG_DIRECTORY;

    private SystemUtilities() {
    }

    public static void initialize() {
        try {
            if (SystemUtilities.isOSWindows2000() || SystemUtilities.isOSWindowsXP() || SystemUtilities.isOSWindowsVista() || SystemUtilities.isOSLinux() || SystemUtilities.isOSMac()) {
                System.loadLibrary("systemutilities");
                isLibraryLoaded = true;
            } else {
                isLibraryLoaded = false;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Common.logException("Error:", unsatisfiedLinkError);
            isLibraryLoaded = false;
        }
    }

    private static void setOperatingSystems() {
        isWindows = false;
        isMac = false;
        isLinux = false;
        String string = System.getProperty("os.name").toLowerCase(Locale.US);
        isWindows = string.indexOf("windows") != -1;
        isWindows2000 = string.indexOf("windows 2000") != -1;
        isWindowsXP = string.indexOf("windows xp") != -1;
        isWindowsVista = string.indexOf("windows vista") != -1;
        boolean bl = isLinux = string.indexOf("linux") != -1;
        if (string.startsWith("mac os")) {
            isMac = true;
        }
    }

    public static boolean isRunOnStartupSupported() {
        return SystemUtilities.isOSWindows();
    }

    public static boolean isOSWindows() {
        return isWindows;
    }

    public static boolean isOSWindowsXP() {
        return isWindowsXP;
    }

    public static boolean isOSWindows2000() {
        return isWindows2000;
    }

    public static boolean isOSWindowsVista() {
        return isWindowsVista;
    }

    public static boolean isOSLinux() {
        return isLinux;
    }

    public static boolean isOSMac() {
        return isMac;
    }

    public static File getLogsDirectory() {
        if (USER_LOG_DIRECTORY == null) {
            USER_LOG_DIRECTORY = SystemUtilities.isOSMac() ? SystemUtilities.getMacLogsDirectory() : SystemUtilities.getUserDataDirectory();
            SystemUtilities.createDirectoryIfMissing(USER_LOG_DIRECTORY);
        }
        return USER_LOG_DIRECTORY;
    }

    public static File getUserHomeDirectory() {
        if (USER_HOME_DIRECTORY == null) {
            USER_HOME_DIRECTORY = new File(System.getProperty("user.home"));
        }
        return USER_HOME_DIRECTORY;
    }

    private static File getUserDefaultDirectory() {
        if (USER_DEFAULT_DIRECTORY == null) {
            USER_DEFAULT_DIRECTORY = new File(SystemUtilities.getUserHomeDirectory(), "." + JApplication.getApplicationName().toLowerCase());
        }
        return USER_DEFAULT_DIRECTORY;
    }

    public static File getUserSettingsDirectory() {
        if (USER_SETTINGS_DIRECTORY == null) {
            if (SystemUtilities.isOSWindows()) {
                USER_SETTINGS_DIRECTORY = SystemUtilities.getWindowsAppDataDirectory();
            } else if (SystemUtilities.isOSMac()) {
                USER_SETTINGS_DIRECTORY = SystemUtilities.getMacSettingsDirectory();
            }
            if (USER_SETTINGS_DIRECTORY == null) {
                USER_SETTINGS_DIRECTORY = SystemUtilities.getUserDefaultDirectory();
            }
            SystemUtilities.createDirectoryIfMissing(USER_SETTINGS_DIRECTORY);
        }
        return USER_SETTINGS_DIRECTORY;
    }

    public static File getUserDataDirectory() {
        if (USER_DATA_DIRECTORY == null) {
            if (SystemUtilities.isOSWindows()) {
                USER_DATA_DIRECTORY = SystemUtilities.getUserSettingsDirectory();
            } else if (SystemUtilities.isOSMac()) {
                USER_DATA_DIRECTORY = SystemUtilities.getMacDataDirectory();
            }
            if (USER_DATA_DIRECTORY == null) {
                USER_DATA_DIRECTORY = SystemUtilities.getUserDefaultDirectory();
            }
            SystemUtilities.createDirectoryIfMissing(USER_DATA_DIRECTORY);
        }
        return USER_DATA_DIRECTORY;
    }

    public static void createDirectoryIfMissing(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            file.delete();
            file.mkdirs();
        }
    }

    private static File getWindowsAppDataDirectory() {
        File file;
        String string = System.getProperty("APPDATA");
        if ("%APPDATA%".equals(string)) {
            return null;
        }
        if (string != null && string.length() > 0 && ((file = new File(string, JApplication.getApplicationName())).isDirectory() || !file.exists())) {
            return file;
        }
        return null;
    }

    private static File getMacSettingsDirectory() {
        return new File(SystemUtilities.getUserHomeDirectory(), "Library/Preferences/" + JApplication.getApplicationName());
    }

    private static File getMacLogsDirectory() {
        return new File(SystemUtilities.getUserHomeDirectory(), "Library/Logs/" + JApplication.getApplicationName());
    }

    private static File getMacDataDirectory() {
        return new File(SystemUtilities.getUserHomeDirectory(), "Library/Application Support/" + JApplication.getApplicationName());
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }

    public static void openURL(final String string) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    BrowserLauncher.openURL((String)string);
                }
                catch (Exception exception) {
                    Common.logException("Error:", exception);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public static void openFile(File file) {
        try {
            SystemUtilities.openURL(file.toURI().toURL().toString());
        }
        catch (Exception exception) {
            Common.logException("Error:", exception);
        }
    }

    public static void openHelpFile(String string) {
        if (SystemUtilities.isOSMac()) {
            SystemUtilities.openFile(new File(SystemUtilities.getPathToHelpFolderInMacBundle(), string));
        } else {
            SystemUtilities.openFile(new File("help/" + string));
        }
    }

    private static String getPathToHelpFolderInMacBundle() {
        String string = ClassLoader.getSystemClassLoader().getResource("com/fanurio/ui/images/fanurio-splash.jpg").toString();
        if (!string.startsWith("jar:file:")) {
            return null;
        }
        if (string.indexOf("Contents/Resources/") == -1) {
            return null;
        }
        String string2 = string.substring("jar:file:".length(), string.indexOf("Contents/Resources/"));
        return string2 + "Contents/Resources/help";
    }

    private static native long getIdleTimeNative();

    private static native void moveToFrontNative(String var0);

    static {
        SystemUtilities.setOperatingSystems();
    }
}

