/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.util;

import com.sbs.jpm.Common;
import com.sbs.util.LockAvoidFileInputStream;
import com.sbs.util.LockAvoidFileOutputStream;
import com.sbs.util.LockException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

public class LockedFile
extends File {
    private File backup;
    public String fileName;
    private FileLock lock;
    private RandomAccessFile raf;

    public void backup() throws IOException {
        int n;
        String string = this.getAbsolutePath();
        string = string.substring(0, string.length() - 4) + ".backup" + string.substring(string.length() - 4);
        File file = new File(string);
        LockAvoidFileInputStream lockAvoidFileInputStream = new LockAvoidFileInputStream(this.raf);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)lockAvoidFileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)lockAvoidFileInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }

    private void lock() throws LockException, IOException {
        this.raf = new RandomAccessFile(this, "rw");
        this.lock = this.raf.getChannel().tryLock();
        if (this.lock == null) {
            throw new LockException(Common.I18N_MESSAGES.getString("lockedFile.notLocked"));
        }
    }

    public void unlock() throws IOException {
        if (this.lock != null) {
            this.lock.release();
            this.lock.channel().close();
        }
        if (this.raf != null) {
            this.raf.close();
        }
        this.lock = null;
        this.raf = null;
    }

    public static LockedFile createOpenedLockedFile(File file) throws LockException, IOException {
        LockedFile lockedFile = new LockedFile(file);
        lockedFile.lock();
        return lockedFile;
    }

    private LockedFile(File file) throws IOException {
        super(file.getAbsolutePath());
        this.fileName = file.getAbsolutePath();
    }

    public LockAvoidFileInputStream getSeek0InputStream() throws IOException {
        return new LockAvoidFileInputStream(this.raf);
    }

    public LockAvoidFileOutputStream getSeek0OutputStream() throws IOException {
        return new LockAvoidFileOutputStream(this.raf);
    }
}

