/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.util;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.CurrencyManager;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.component.JHumanResourcesTable;
import com.sbs.jpm.ui.component.JMaterialResourcesTable;
import com.sbs.jpm.ui.component.model.HumanResourcesTableModel;
import com.sbs.jpm.ui.component.model.MaterialResourcesTableModel;
import com.sbs.jpm.ui.component.util.TaskDurationFormat;
import com.sbs.jpm.ui.component.util.TaskWorkDurationFormat;
import com.sbs.jpm.ui.treetablechart.JEPSTable;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.jpm.ui.treetablechart.model.EPSTableModel;
import com.sbs.jpm.ui.treetablechart.model.TaskTreeTableModel;
import com.sbs.util.SystemUtilities;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXTable;

public class ExcelAdapter
implements ActionListener {
    private String rowstring;
    private String value;
    private Clipboard system;
    private StringSelection stsel;
    private JTable jTable1;

    public ExcelAdapter(JTable jTable) {
        this.jTable1 = jTable;
        KeyStroke keyStroke = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(67, 256) : KeyStroke.getKeyStroke(67, 128);
        KeyStroke keyStroke2 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(86, 256) : KeyStroke.getKeyStroke(86, 128);
        this.jTable1.registerKeyboardAction(this, "Copy", keyStroke, 0);
        this.jTable1.registerKeyboardAction(this, "Paste", keyStroke2, 0);
        this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public JTable getJTable() {
        return this.jTable1;
    }

    public void setJTable(JTable jTable) {
        this.jTable1 = jTable;
    }

    public static String tasksToString(JTreeTable jTreeTable) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = jTreeTable.getColumnCount(false);
        int n2 = jTreeTable.getSelectedRowCount();
        int[] nArray = jTreeTable.getSelectedRows();
        List list = jTreeTable.getColumns(false);
        for (int i = 0; i < n2; ++i) {
            Task task = (Task)jTreeTable.getPathForRow(nArray[i]).getLastPathComponent();
            if (task.isEmpty()) continue;
            int n3 = 0;
            for (TableColumn tableColumn : list) {
                String string;
                Object object = jTreeTable.getTreeTableModel().getValueAt((Object)task, tableColumn.getModelIndex());
                String string2 = string = object == null ? "" : object.toString();
                if (object != null) {
                    Serializable serializable;
                    if (tableColumn.getIdentifier().equals(TaskTreeTableModel.INFO)) {
                        string = "";
                    } else if (tableColumn.getIdentifier().equals(TaskTreeTableModel.DURATION) || tableColumn.getIdentifier().equals(TaskTreeTableModel.ACTUAL_DURATION) || tableColumn.getIdentifier().equals(TaskTreeTableModel.REMAINING_DURATION)) {
                        string = TaskDurationFormat.formatDuration(task, (Long)object);
                    } else if (tableColumn.getIdentifier().equals(TaskTreeTableModel.START) || tableColumn.getIdentifier().equals(TaskTreeTableModel.ACTUAL_START) || tableColumn.getIdentifier().equals(TaskTreeTableModel.ACTUAL_END) || tableColumn.getIdentifier().equals(TaskTreeTableModel.END)) {
                        if (object != null) {
                            serializable = new SimpleDateFormat(UIManager.getInstance().getDateFormat());
                            string = serializable.format((Date)object);
                        } else {
                            string = "";
                        }
                    } else if (tableColumn.getIdentifier().equals(TaskTreeTableModel.PERCENT_COMPLETE) || tableColumn.getIdentifier().equals(TaskTreeTableModel.PERCENT_WORK_COMPLETE)) {
                        double d = (Double)object;
                        NumberFormat numberFormat = NumberFormat.getPercentInstance();
                        string = numberFormat.format(d / 100.0);
                    } else if (tableColumn.getIdentifier().equals(TaskTreeTableModel.FIXED_COST) || tableColumn.getIdentifier().equals(TaskTreeTableModel.COST) || tableColumn.getIdentifier().equals(TaskTreeTableModel.ACTUAL_COST) || tableColumn.getIdentifier().equals(TaskTreeTableModel.REMAINING_COST)) {
                        serializable = (Double)object;
                        Formatter formatter = new Formatter();
                        formatter.format(jTreeTable.getProject().getCompany().getRootTask().getCurrencyUnit() + "%." + CurrencyManager.getFractionDigits() + "f", serializable);
                        string = formatter.toString();
                    } else if (tableColumn.getIdentifier().equals(TaskTreeTableModel.WORK) || tableColumn.getIdentifier().equals(TaskTreeTableModel.ACTUAL_WORK) || tableColumn.getIdentifier().equals(TaskTreeTableModel.REMAINING_WORK)) {
                        string = TaskWorkDurationFormat.formatWork(task, (Long)object);
                    }
                }
                stringBuffer.append(string);
                if (n3 < n - 1) {
                    stringBuffer.append("\t");
                }
                ++n3;
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String resourcesToString(JXTable jXTable) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = jXTable.getColumnCount(false);
        int n2 = jXTable.getSelectedRowCount();
        int[] nArray = jXTable.getSelectedRows();
        List list = jXTable.getColumns(false);
        for (int i = 0; i < n2; ++i) {
            Resource resource;
            Task task;
            if (jXTable instanceof JHumanResourcesTable) {
                task = ((JHumanResourcesTable)jXTable).getProject();
                if (nArray[i] > task.getCompany().getHumanResourcesNumber() - 1) continue;
                resource = task.getCompany().getHumanResourceAt(nArray[i]);
            } else {
                task = ((JMaterialResourcesTable)jXTable).getProject();
                if (nArray[i] > task.getCompany().getMaterialResourcesNumber() - 1) continue;
                resource = task.getCompany().getMaterialResourceAt(nArray[i]);
            }
            if (resource.isEmpty()) continue;
            int n3 = 0;
            for (TableColumn tableColumn : list) {
                String string;
                Object object = jXTable.getValueAt(nArray[i], jXTable.convertColumnIndexToView(tableColumn.getModelIndex()));
                String string2 = string = object == null ? "" : object.toString();
                if (object != null) {
                    Formatter formatter;
                    Double d;
                    if (tableColumn.getIdentifier().equals(MaterialResourcesTableModel.PRICE_PER_UNIT)) {
                        d = (Double)object;
                        formatter = new Formatter();
                        formatter.format(task.getCompany().getRootTask().getCurrencyUnit() + "%." + CurrencyManager.getFractionDigits() + "f", d);
                        string = formatter.toString();
                    } else if (tableColumn.getIdentifier().equals(HumanResourcesTableModel.STANDARD_RATE) || tableColumn.getIdentifier().equals(HumanResourcesTableModel.OVERTIME_RATE)) {
                        d = (Double)object;
                        formatter = new Formatter();
                        formatter.format(task.getCompany().getRootTask().getCurrencyUnit() + "%." + CurrencyManager.getFractionDigits() + "f/h", d);
                        string = formatter.toString();
                    }
                }
                stringBuffer.append(string);
                if (n3 < n - 1) {
                    stringBuffer.append("\t");
                }
                ++n3;
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String toString(JXTable jXTable) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = jXTable.getColumnCount(false);
        int n2 = jXTable.getSelectedRowCount();
        int[] nArray = jXTable.getSelectedRows();
        List list = jXTable.getColumns(false);
        for (int i = 0; i < n2; ++i) {
            int n3 = 0;
            for (TableColumn tableColumn : list) {
                stringBuffer.append(jXTable.getValueAt(nArray[i], tableColumn.getModelIndex()));
                if (n3 >= n - 1) continue;
                stringBuffer.append("\t");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String projectsToString(JXTable jXTable) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = jXTable.getColumnCount(false);
        int n2 = jXTable.getSelectedRowCount();
        int[] nArray = jXTable.getSelectedRows();
        List list = jXTable.getColumns(false);
        Task task = ((JEPSTable)jXTable).getProject().getCompany().getRootTask();
        for (int i = 0; i < n2; ++i) {
            Task task2 = task.getProjectChildAt(nArray[i]);
            int n3 = 0;
            for (TableColumn tableColumn : list) {
                String string;
                Object object = jXTable.getValueAt(nArray[i], jXTable.convertColumnIndexToView(tableColumn.getModelIndex()));
                String string2 = string = object == null ? "" : object.toString();
                if (object != null) {
                    Serializable serializable;
                    if (tableColumn.getIdentifier().equals(EPSTableModel.DURATION)) {
                        string = TaskDurationFormat.formatDuration(task2, (Long)object);
                    } else if (tableColumn.getIdentifier().equals(EPSTableModel.START) || tableColumn.getIdentifier().equals(EPSTableModel.ESTIMATED_START) || tableColumn.getIdentifier().equals(EPSTableModel.END)) {
                        if (object != null) {
                            serializable = new SimpleDateFormat(UIManager.getInstance().getDateFormat());
                            string = serializable.format((Date)object);
                        } else {
                            string = "";
                        }
                    } else if (tableColumn.getIdentifier().equals(EPSTableModel.PERCENT_COMPLETE) || tableColumn.getIdentifier().equals(EPSTableModel.PERCENT_WORK_COMPLETE)) {
                        double d = (Double)object;
                        NumberFormat numberFormat = NumberFormat.getPercentInstance();
                        string = numberFormat.format(d / 100.0);
                    } else if (tableColumn.getIdentifier().equals(EPSTableModel.COST)) {
                        serializable = (Double)object;
                        Formatter formatter = new Formatter();
                        formatter.format(task2.getCompany().getRootTask().getCurrencyUnit() + "%." + CurrencyManager.getFractionDigits() + "f", serializable);
                        string = formatter.toString();
                    } else if (tableColumn.getIdentifier().equals(EPSTableModel.WORK)) {
                        string = TaskWorkDurationFormat.formatWork(task2, (Long)object);
                    }
                }
                stringBuffer.append(string);
                if (n3 >= n - 1) continue;
                stringBuffer.append("\t");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object;
        int n2;
        if (actionEvent.getActionCommand().compareTo("Copy") == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            n2 = this.jTable1.getSelectedColumnCount();
            int n3 = this.jTable1.getSelectedRowCount();
            object = this.jTable1.getSelectedRows();
            int[] nArray = this.jTable1.getSelectedColumns();
            if (n3 - 1 != object[((int[])object).length - 1] - object[0] || n3 != ((int[])object).length || n2 - 1 != nArray[nArray.length - 1] - nArray[0] || n2 != nArray.length) {
                JOptionPane.showMessageDialog(null, Common.I18N_MESSAGES.getString("excelAdapter.invalidCopySelection"), Common.I18N_MESSAGES.getString("excelAdapter.invalidCopySelection"), 0);
                return;
            }
            for (int i = 0; i < n3; ++i) {
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(this.jTable1.getValueAt((int)object[i], nArray[n]));
                    if (n >= n2 - 1) continue;
                    stringBuffer.append("\t");
                }
                stringBuffer.append("\n");
            }
            this.stsel = new StringSelection(stringBuffer.toString());
            this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.system.setContents(this.stsel, this.stsel);
        }
        if (actionEvent.getActionCommand().compareTo("Paste") == 0) {
            int n4 = this.jTable1.getSelectedRows()[0];
            n2 = this.jTable1.getSelectedColumns()[0];
            try {
                String string = (String)this.system.getContents(this).getTransferData(DataFlavor.stringFlavor);
                object = new StringTokenizer(string, "\n");
                int n5 = 0;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    this.rowstring = ((StringTokenizer)object).nextToken();
                    StringTokenizer stringTokenizer = new StringTokenizer(this.rowstring, "\t");
                    n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        this.value = stringTokenizer.nextToken();
                        if (n4 + n5 < this.jTable1.getRowCount() && n2 + n < this.jTable1.getColumnCount()) {
                            this.jTable1.setValueAt(this.value, n4 + n5, n2 + n);
                        }
                        ++n;
                    }
                    ++n5;
                }
            }
            catch (Exception exception) {
                Common.logException("Error:", exception);
                exception.printStackTrace();
            }
        }
    }
}

