/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskWorkCompletionEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long uniqueId;
    private Task task;
    private double oldCompletion;
    private double newCompletion;
    private String actionId;

    public TaskWorkCompletionEdit(Task task, double d, double d2, String string) {
        this.task = task;
        this.uniqueId = task.getUniqueId();
        this.oldCompletion = d;
        this.newCompletion = d2;
        this.actionId = task.getName();
        Common.log("Action: " + string + " - task work completion edit - task: " + task.getFullName() + " - old: " + d + " new: " + d2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.task.setWorkCompletion(this.oldCompletion, true);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.task.setWorkCompletion(this.newCompletion, true);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.uniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.task);
        }
    }

    @Override
    public void serialize() {
        this.task = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.task != null) {
            this.task.setWorkCompletion(this.newCompletion, true);
            return null;
        }
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("task work completion edit", this.actionId, "Task no longer exists."));
        return vector;
    }
}

