/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.core.ActualWorkingData;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.CircularRelationshipException;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.core.constraint.Constraint;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskSplitEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task task;
    private long taskUniqueId;
    private Date splitDate;
    private double oldCompletion;
    private ActualWorkingData oldData;
    private Assignment[] oldAssignments;
    private CalendarManager oldCalendar;
    private Constraint oldConstraint;
    public Task t1;
    public Task t2;
    public long t1Id;
    public long t2Id;
    public Dependency dependency;
    public long dependencyId;
    private Assignment[] t1Assignments;
    private Assignment[] t2Assignments;
    public Vector<Long> t1AssIDs = new Vector();
    public Vector<Long> t2AssIDs = new Vector();
    private String actionId;

    public TaskSplitEdit(Task task, Date date, Task task2, Task task3, Dependency dependency, List<Assignment> list, String string) {
        System.out.println("create split at: " + date);
        this.task = task;
        this.actionId = task.getName();
        this.taskUniqueId = task.getUniqueId();
        this.splitDate = date;
        this.t1 = task2;
        this.t2 = task3;
        this.t1Id = task2.getUniqueId();
        this.t2Id = task3.getUniqueId();
        this.dependency = dependency;
        this.dependencyId = dependency.getUniqueId();
        this.oldData = task.getData();
        this.oldCalendar = task.getCalendar();
        this.oldCompletion = task.getCompletion();
        this.oldConstraint = task.getConstraint();
        this.oldAssignments = new Assignment[list.size()];
        this.t1Assignments = new Assignment[list.size()];
        this.t2Assignments = new Assignment[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Assignment assignment;
            this.oldAssignments[i] = assignment = list.get(i);
            this.t1Assignments[i] = task2.getAssignmentAt(i);
            this.t2Assignments[i] = task3.getAssignmentAt(i);
            this.t1AssIDs.add(task2.getAssignmentAt(i).getUniqueId());
            this.t2AssIDs.add(task3.getAssignmentAt(i).getUniqueId());
        }
        Common.log("Action: " + string + " - task split edit - task: " + task.getFullName());
    }

    @Override
    public void undo() throws CannotUndoException {
        int n;
        super.undo();
        for (n = 0; n < this.oldAssignments.length; ++n) {
            Assignment assignment = this.oldAssignments[n];
            assignment.getResource().addAssignment(assignment);
            this.task.addAssignment(assignment);
        }
        this.task.setCalendar(this.oldCalendar);
        this.task.setConstraint(this.oldConstraint);
        for (n = this.task.getChildNumber() - 1; n > 0; --n) {
            this.task.deleteChild(this.task.getChildAt(n));
        }
        this.task.setData(this.oldData);
        this.task.setCompletion(this.oldCompletion);
        this.task.setSplitted(false);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.task.setSplitted(true);
        this.task.addChild(this.t1, false);
        this.task.addChild(this.t2, false);
        try {
            Task.addDependency(this.dependency, false);
        }
        catch (CircularRelationshipException circularRelationshipException) {
            circularRelationshipException.printStackTrace();
            Common.logException("Error:", circularRelationshipException);
        }
        int n = 0;
        for (Assignment assignment : this.task.getAssignments()) {
            Resource resource = assignment.getResource();
            this.t1.addAssignment(this.t1Assignments[n]);
            resource.addAssignment(this.t1Assignments[n]);
            this.t2.addAssignment(this.t2Assignments[n]);
            resource.addAssignment(this.t2Assignments[n]);
            ++n;
        }
        while (this.task.getAssignments().size() > 0) {
            Assignment assignment = this.task.getAssignmentAt(0);
            assignment.getResource().removeAssignment(assignment);
            this.task.removeAssignment(0);
        }
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.taskUniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.taskUniqueId);
        }
        if (this.task != null) {
            hashMap.put(this.taskUniqueId, this.task);
            this.task.split(this.splitDate, this);
            hashMap.put(this.t1Id, this.t1);
            hashMap.put(this.t2Id, this.t2);
            uniqueIdContainer.newElement(this.t1);
            uniqueIdContainer.newElement(this.t2);
            hashMap.put(this.dependencyId, this.dependency);
            uniqueIdContainer.newElement(this.dependency);
            for (int i = 0; i < this.t1.getAssignmentNumber(); ++i) {
                Assignment assignment = this.t1.getAssignmentAt(i);
                hashMap.put(assignment.getUniqueId(), assignment);
                uniqueIdContainer.newElement(assignment);
                assignment = this.t2.getAssignmentAt(i);
                hashMap.put(assignment.getUniqueId(), assignment);
                uniqueIdContainer.newElement(assignment);
            }
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.task != null) {
            return null;
        }
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("task work edit", this.actionId, "Task no longer exists."));
        return vector;
    }

    @Override
    public void serialize() {
        this.task = null;
        this.oldData = null;
        this.oldAssignments = null;
        this.oldCalendar = null;
        this.oldConstraint = null;
        this.t1 = null;
        this.t2 = null;
        this.dependency = null;
        this.t1Assignments = null;
        this.t2Assignments = null;
    }
}

