/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.CircularRelationshipException;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.Task;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPasteEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private Task parent;
    private Task child;
    private int index;
    private List<Dependency> predecessorsDependencies;
    private List<Dependency> successorsDependencies;
    private List<Assignment> assignments;

    public TaskPasteEdit(Task task, Task task2, int n, List<Dependency> list, List<Dependency> list2, List<Assignment> list3, String string) {
        this.parent = task;
        this.child = task2;
        this.index = n;
        this.predecessorsDependencies = list;
        this.successorsDependencies = list2;
        this.assignments = list3;
        Common.log("Action: " + string + " - task paste edit - task: " + task2.getFullName() + " - parent: " + task.getFullName());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.parent.deleteChild(this.child);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.parent.addChild(this.index, this.child);
            for (Dependency uniqueId : this.predecessorsDependencies) {
                Task.addDependency(uniqueId, false);
            }
            for (Dependency dependency : this.successorsDependencies) {
                Task.addDependency(dependency, false);
            }
            for (Assignment assignment : this.assignments) {
                assignment.getTask().addAssignment(assignment);
                assignment.getResource().addAssignment(assignment);
            }
        }
        catch (CircularRelationshipException circularRelationshipException) {
            Common.logException("Error:", circularRelationshipException);
        }
    }
}

