/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.ActualWorkingData;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.CircularRelationshipException;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.core.constraint.Constraint;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPartSplitEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task task;
    private long taskUniqueId;
    private Date splitDate;
    private double oldCompletion;
    private ActualWorkingData oldData;
    private Constraint oldConstraint;
    private double newCompletion;
    private ActualWorkingData newData;
    private Constraint newConstraint;
    public Task t1;
    public long t1Id;
    public Dependency dependency;
    public long dependencyId;
    public Vector<Long> t1AssIDs = new Vector();
    private Assignment[] t1Assignments;

    public TaskPartSplitEdit(Task task, Date date, ActualWorkingData actualWorkingData, double d, Constraint constraint, Task task2, Dependency dependency, String string) {
        this.task = task;
        this.taskUniqueId = task.getUniqueId();
        this.splitDate = date;
        this.t1 = task2;
        this.t1Id = task2.getUniqueId();
        this.dependency = dependency;
        this.dependencyId = dependency.getUniqueId();
        this.oldData = actualWorkingData;
        this.oldCompletion = d;
        this.oldConstraint = constraint;
        this.newData = task.getData();
        this.newCompletion = task.getCompletion();
        this.newConstraint = task.getConstraint();
        this.t1Assignments = new Assignment[task2.getAssignmentNumber()];
        for (int i = 0; i < task2.getAssignmentNumber(); ++i) {
            this.t1AssIDs.add(task2.getAssignmentAt(i).getUniqueId());
            this.t1Assignments[i] = task2.getAssignmentAt(i);
        }
        Common.log("Action: " + string + " - task part split edit - task: " + task.getFullName() + " - split date: " + date);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        LinkedList<Dependency> linkedList = new LinkedList<Dependency>();
        for (Dependency dependency : this.t1.getSuccessorDependencies()) {
            if (dependency.getType() == 0 && dependency.getType() == 3) continue;
            linkedList.add(dependency);
        }
        for (Dependency dependency : linkedList) {
            Task.removeDependency(dependency);
            dependency.setPredecessor(this.task);
            try {
                Task.addDependency(dependency, true);
            }
            catch (CircularRelationshipException circularRelationshipException) {
                Common.logException("Error:", circularRelationshipException);
                circularRelationshipException.printStackTrace();
            }
        }
        this.task.getParent().deleteChild(this.t1);
        this.task.setData(this.oldData);
        this.task.setConstraint(this.oldConstraint);
        this.task.setCompletion(this.oldCompletion);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.task.getParent().addChild(this.task.getParent().getChildIndex(this.task) + 1, this.t1);
        LinkedList<Dependency> linkedList = new LinkedList<Dependency>();
        for (Dependency uniqueId : this.task.getSuccessorDependencies()) {
            if (uniqueId.getType() == 0 && uniqueId.getType() == 3) continue;
            linkedList.add(uniqueId);
        }
        for (Dependency dependency : linkedList) {
            Task.removeDependency(dependency);
            dependency.setPredecessor(this.t1);
            try {
                Task.addDependency(dependency, true);
            }
            catch (CircularRelationshipException circularRelationshipException) {
                Common.logException("Error:", circularRelationshipException);
                circularRelationshipException.printStackTrace();
            }
        }
        try {
            Task.addDependency(this.dependency, true);
        }
        catch (CircularRelationshipException circularRelationshipException) {
            circularRelationshipException.printStackTrace();
            Common.logException("Error:", circularRelationshipException);
        }
        int n = 0;
        for (Assignment assignment : this.task.getAssignments()) {
            Resource resource = assignment.getResource();
            this.t1.addAssignment(this.t1Assignments[n]);
            resource.addAssignment(this.t1Assignments[n]);
            ++n;
        }
        this.task.setData(this.newData);
        this.task.setConstraint(this.newConstraint);
        this.task.setCompletion(this.newCompletion);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.taskUniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.taskUniqueId);
            hashMap.put(this.taskUniqueId, this.task);
        }
        if (this.task != null) {
            this.task.splitPart(this.splitDate, this);
            hashMap.put(this.t1Id, this.t1);
            uniqueIdContainer.newElement(this.t1);
            hashMap.put(this.dependencyId, this.dependency);
            uniqueIdContainer.newElement(this.dependency);
            for (int i = 0; i < this.t1.getAssignmentNumber(); ++i) {
                Assignment assignment = this.t1.getAssignmentAt(i);
                hashMap.put(assignment.getUniqueId(), assignment);
                uniqueIdContainer.newElement(assignment);
            }
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        return null;
    }

    @Override
    public void serialize() {
        this.task = null;
        this.oldData = null;
        this.oldConstraint = null;
        this.t1 = null;
        this.dependency = null;
        this.t1Assignments = null;
    }
}

