/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.CircularRelationshipException;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskOutdentEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task oldParent;
    private long taskUniqueId;
    private Task task;

    public TaskOutdentEdit(Task task, Task task2, String string) {
        this.oldParent = task;
        this.task = task2;
        Common.log("Action: " + string + " - task outdent edit - task: " + task2.getFullName() + " - old parent: " + task.getFullName());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        try {
            this.task.indent(this.oldParent);
        }
        catch (CircularRelationshipException circularRelationshipException) {
            Common.logException("Error:", circularRelationshipException);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.task.outdent();
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.taskUniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.taskUniqueId);
            hashMap.put(this.taskUniqueId, this.task);
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.task != null) {
            this.task.outdent();
        }
        return null;
    }

    @Override
    public void serialize() {
        this.oldParent = null;
    }
}

