/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskInsertEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task parent;
    private long parentUniqueId;
    private Task child;
    private long childUniqueId;
    private int index;
    private String actionId;

    public TaskInsertEdit(Task task, Task task2, int n, String string) {
        this.parent = task;
        this.child = task2;
        this.index = n;
        this.parentUniqueId = task.getUniqueId();
        this.childUniqueId = task2.getUniqueId();
        this.actionId = task.getName();
        Common.log("Action: " + string + " - task insert edit - task: " + task2.getFullName() + " - parent: " + task.getFullName());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.parent.deleteChild(this.child);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.parent.addChild(this.index, this.child);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.parent = (Task)hashMap.get(this.parentUniqueId);
        if (this.parent == null) {
            this.parent = company.getTaskForUniqueId(this.parentUniqueId);
            hashMap.put(this.parentUniqueId, this.parent);
        }
        if (this.parent != null) {
            this.child = new Task(this.childUniqueId);
            uniqueIdContainer.newElement(this.child);
            hashMap.put(this.childUniqueId, this.child);
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.parent != null) {
            if (this.parent.getChildNumber() < this.index) {
                this.index = this.parent.getChildNumber();
            }
            this.parent.addChild(this.index, this.child);
            return null;
        }
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("insert new task", this.actionId, "Parent task no longer exists."));
        return vector;
    }

    @Override
    public void serialize() {
        this.parent = null;
        this.child = null;
    }
}

