/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.CircularRelationshipException;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskIndentEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task newParent;
    private long newParentId;
    private Task task;
    private long taskUniqueId;
    private String actionId;

    public TaskIndentEdit(Task task, Task task2, String string) {
        this.newParent = task;
        this.task = task2;
        this.taskUniqueId = task2.getUniqueId();
        this.newParentId = task.getUniqueId();
        this.actionId = task2.getName();
        Common.log("Action: " + string + " - task indent edit - task: " + task2.getFullName() + " - new parent: " + task.getFullName());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.task.outdent();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.task.indent(this.newParent);
        }
        catch (CircularRelationshipException circularRelationshipException) {
            Common.logException("Error:", circularRelationshipException);
        }
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.taskUniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.taskUniqueId);
            hashMap.put(this.taskUniqueId, this.task);
        }
        this.newParent = (Task)hashMap.get(this.newParentId);
        if (this.newParent == null) {
            this.newParent = company.getTaskForUniqueId(this.newParentId);
            hashMap.put(this.newParentId, this.newParent);
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.task != null && this.newParent != null) {
            try {
                this.task.indent(this.newParent);
                return null;
            }
            catch (CircularRelationshipException circularRelationshipException) {
                Common.logException("Error:", circularRelationshipException);
            }
        }
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("Indent task", this.actionId, "Either task or the new parent no longer exists or indenting task would generate a circular relashionship."));
        return vector;
    }

    @Override
    public void serialize() {
        this.newParent = null;
        this.task = null;
    }
}

