/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.CircularRelationshipException;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDeleteEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task parent;
    private Task child;
    private Task partChild;
    private int partChildIndex;
    private int index;
    private List<Dependency> predecessors;
    private List<Dependency> successors;
    private List<Assignment> assignments;
    private boolean parentWasSplitted;
    private long childUniqueId;
    private String actionId;

    public TaskDeleteEdit(Task task, Task task2, int n, List<Dependency> list, List<Dependency> list2, List<Assignment> list3, int n2) {
        this.parent = task;
        this.parentWasSplitted = task.isSplitted();
        if (this.parentWasSplitted && task.getChildNumber() == 2) {
            this.partChildIndex = 1 - task.getChildIndex(task2);
            this.partChild = task.getChildAt(this.partChildIndex);
        }
        this.child = task2;
        this.index = n;
        this.predecessors = list;
        this.successors = list2;
        this.assignments = list3;
        this.actionId = task2.getName();
        this.childUniqueId = task2.getUniqueId();
        Common.log("Action: " + n2 + " - task deleted - task: " + task2.getFullName());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        try {
            if (this.parentWasSplitted) {
                if (this.partChild != null) {
                    if (this.partChildIndex == 1) {
                        this.parent.addChild(this.index, this.child);
                        this.parent.addChild(this.partChildIndex, this.partChild);
                    } else {
                        this.parent.addChild(this.partChildIndex, this.partChild);
                        this.parent.addChild(this.index, this.child);
                    }
                } else {
                    for (Dependency uniqueId : this.predecessors) {
                        Task task = uniqueId.getPredecessor();
                        if (task.getSuccessorDependencies().size() == 0) continue;
                        Task.removeDependency(task.getSuccessorDependencies().get(0));
                    }
                    this.parent.addChild(this.index, this.child);
                }
            } else {
                this.parent.addChild(this.index, this.child);
            }
            for (Dependency dependency : this.predecessors) {
                Task.addDependency(dependency, false);
            }
            for (Dependency dependency : this.successors) {
                Task.addDependency(dependency, false);
            }
            for (Assignment assignment : this.assignments) {
                assignment.getTask().addAssignment(assignment);
                assignment.getResource().addAssignment(assignment);
            }
            this.parent.setSplitted(this.parentWasSplitted);
        }
        catch (CircularRelationshipException circularRelationshipException) {
            Common.logException("Error:", circularRelationshipException);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.parent.deleteChild(this.child);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.child = (Task)hashMap.get(this.childUniqueId);
        if (this.child == null) {
            this.child = company.getTaskForUniqueId(this.childUniqueId);
        }
        if (this.child != null) {
            this.parent = this.child.getParent();
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.parent != null && this.child != null) {
            this.parent.deleteChild(this.child);
            return null;
        }
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("Task delete", this.actionId, "Task no longer exists."));
        return vector;
    }

    @Override
    public void serialize() {
        this.parent = null;
        this.partChild = null;
        this.child = null;
        this.predecessors = null;
        this.successors = null;
        this.assignments = null;
    }
}

