/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDeadlineEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long taskUniqueId;
    private Task task;
    private Date oldDeadline;
    private Date newDeadline;

    public TaskDeadlineEdit(Task task, Date date, Date date2, String string) {
        this.task = task;
        this.taskUniqueId = task.getUniqueId();
        this.oldDeadline = date;
        this.newDeadline = date2;
        Common.log("Action: " + string + " - task deadline edit - task: " + task.getFullName() + " - old: " + date + " new: " + date2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.task.setDeadlineDate(this.oldDeadline);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.task.setDeadlineDate(this.newDeadline);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.taskUniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.taskUniqueId);
            hashMap.put(this.taskUniqueId, this.task);
        }
    }

    @Override
    public void serialize() {
        this.task = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.task != null) {
            this.task.setDeadlineDate(this.newDeadline);
        }
        return null;
    }
}

