/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskCompletionEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long taskUniqueId;
    private Task task;
    private double oldCompletion;
    private double newCompletion;

    public TaskCompletionEdit(Task task, double d, double d2, String string) {
        this.task = task;
        this.taskUniqueId = task.getUniqueId();
        this.oldCompletion = d;
        this.newCompletion = d2;
        Common.log("Action: " + string + " - task completion edit - task: " + task.getFullName() + " - old: " + d + " new: " + d2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.task.setCompletion(this.oldCompletion);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.task.setCompletion(this.newCompletion);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.taskUniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.taskUniqueId);
            hashMap.put(this.taskUniqueId, this.task);
        }
    }

    @Override
    public void serialize() {
        this.task = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.task != null) {
            this.task.setCompletion(this.newCompletion);
        }
        return null;
    }
}

