/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.CircularRelationshipException;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskAddDependencyEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Dependency dependency;
    private long dependencyID;
    private long predID;
    private long succID;
    private String actionId;

    public TaskAddDependencyEdit(Dependency dependency, String string) {
        this.dependency = dependency;
        this.dependencyID = dependency.getUniqueId();
        this.predID = dependency.getPredecessor().getUniqueId();
        this.succID = dependency.getSuccessor().getUniqueId();
        this.actionId = dependency.getPredecessor().getName() + " -> " + dependency.getSuccessor().getName();
        Common.log("Action: " + string + " - task add dependency edit - predecessor: " + dependency.getPredecessor().getFullName() + " - successor: " + dependency.getSuccessor().getFullName());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        Task.removeDependency(this.dependency);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        try {
            Task.addDependency(this.dependency, false);
        }
        catch (CircularRelationshipException circularRelationshipException) {
            Common.logException("Error:", circularRelationshipException);
        }
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        Task task;
        Task task2 = (Task)hashMap.get(this.succID);
        if (task2 == null) {
            task2 = company.getTaskForUniqueId(this.succID);
            hashMap.put(this.succID, task2);
        }
        if ((task = (Task)hashMap.get(this.predID)) == null) {
            task = company.getTaskForUniqueId(this.predID);
            hashMap.put(this.predID, task);
        }
        if (task != null && task2 != null) {
            this.dependency = new Dependency(this.dependencyID);
            this.dependency.setPredecessor(task);
            this.dependency.setSuccessor(task2);
            hashMap.put(this.dependencyID, this.dependency);
            uniqueIdContainer.newElement(this.dependency);
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.dependency != null) {
            try {
                Task.addDependency(this.dependency, false);
            }
            catch (CircularRelationshipException circularRelationshipException) {
                Common.logException("Error:", circularRelationshipException);
                Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
                vector.add(new FailedSerializableEdit("create new dependency", this.actionId, "Dependency would create a circular relationship :" + circularRelationshipException.getMessage()));
                return vector;
            }
            return null;
        }
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("create new dependency", this.actionId, "Either preddecessor or successor task no longer exists."));
        return vector;
    }

    @Override
    public void serialize() {
        this.dependency = null;
    }
}

