/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Risk;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiskInsertEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task task;
    private long taskUniqueId;
    private Risk risk;
    private int index;

    public RiskInsertEdit(Task task, Risk risk, int n, String string) {
        this.task = task;
        this.taskUniqueId = task.getUniqueId();
        this.risk = risk;
        this.index = n;
        Common.log("Action: " + string + " - risk inserted - " + risk.getDescription());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.task.removeRiskAt(this.index);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.task.addRiskAt(this.index, this.risk);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.taskUniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.taskUniqueId);
            hashMap.put(this.taskUniqueId, this.task);
        }
        if (this.task != null) {
            this.task.addRiskAt(this.index, this.risk);
            hashMap.put(this.risk.getUniqueId(), this.risk);
            uniqueIdContainer.newElement(this.risk);
        }
    }

    @Override
    public void serialize() {
        this.task = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        return null;
    }
}

