/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceInsertEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Company company;
    private Resource resource;
    private long resourceId;
    private boolean humanType;
    private boolean fromPaste;
    private int index;

    public ResourceInsertEdit(Company company, Resource resource, int n, boolean bl, String string) {
        this.company = company;
        this.resource = resource;
        this.resourceId = resource.getUniqueId();
        this.humanType = resource instanceof HumanResource;
        this.index = n;
        this.fromPaste = bl;
        Common.log("Action: " + string + " - resource inserted - resource: " + resource.getName() + " - index: " + n + " from paste: " + bl);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.company.removeResource(this.resource);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.humanType) {
            if (this.company.getHumanResourcesNumber() < this.index || this.index < 0) {
                this.index = this.company.getHumanResourcesNumber();
            }
        } else if (this.company.getMaterialResourcesNumber() < this.index || this.index < 0) {
            this.index = this.company.getMaterialResourcesNumber();
        }
        this.company.addResource(this.index, this.resource);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.company = company;
        this.resource = this.humanType ? new HumanResource(this.resourceId) : new MaterialResource(this.resourceId);
        hashMap.put(this.resourceId, this.resource);
        uniqueIdContainer.newElement(this.resource);
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.humanType) {
            if (this.company.getHumanResourcesNumber() < this.index || this.index < 0) {
                this.index = this.company.getHumanResourcesNumber();
            }
        } else if (this.company.getMaterialResourcesNumber() < this.index || this.index < 0) {
            this.index = this.company.getMaterialResourcesNumber();
        }
        this.company.addResource(this.index, this.resource);
        return null;
    }

    @Override
    public void serialize() {
        this.company = null;
        if (!this.fromPaste) {
            this.resource = null;
        }
    }
}

