/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDeleteEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Company company;
    private Resource resource;
    private long resourceId;
    private Assignment[] assignments;
    private int index;

    public ResourceDeleteEdit(Company company, Resource resource, int n, String string) {
        this.company = company;
        this.resource = resource;
        this.index = n;
        this.resourceId = resource.getUniqueId();
        this.assignments = resource.getAssignments().toArray(new Assignment[0]);
        Common.log("Action: " + string + " - resource deleted - resource: " + resource.getName());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.company.addResource(this.index, this.resource);
        for (int i = 0; i < this.assignments.length; ++i) {
            Assignment assignment = this.assignments[i];
            Task task = assignment.getTask();
            task.addAssignment(assignment);
            this.resource.addAssignment(assignment);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.company.removeResource(this.resource);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.company = company;
        this.resource = (Resource)hashMap.get(this.resourceId);
        if (this.resource == null) {
            this.resource = company.getResourceForUniqueId(this.resourceId);
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.resource != null) {
            this.company.removeResource(this.resource);
        }
        return null;
    }

    @Override
    public void serialize() {
        this.company = null;
        this.resource = null;
        this.assignments = null;
    }
}

