/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAdditionalFieldEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long uniqueId;
    private Resource resource;
    private String oldField;
    private String newField;
    private int index;

    public ResourceAdditionalFieldEdit(Resource resource, String string, String string2, int n, String string3) {
        this.resource = resource;
        this.uniqueId = resource.getUniqueId();
        this.oldField = string;
        this.newField = string2;
        this.index = n;
        Common.log("Action: " + string3 + " - resource additional field edit - resource: " + resource.getName() + " - old: " + string + " new: " + string2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.resource.setFieldAt(this.index, this.oldField);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.resource.setFieldAt(this.index, this.newField);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.resource = (Resource)hashMap.get(this.uniqueId);
        if (this.resource == null) {
            this.resource = company.getResourceForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.resource);
        }
    }

    @Override
    public void serialize() {
        this.resource = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.resource != null) {
            this.resource.setFieldAt(this.index, this.newField);
        }
        return null;
    }
}

