/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Link;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkNameEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Link link;
    private long linkUniqueId;
    private String oldName;
    private String newName;
    private String actionId;

    public LinkNameEdit(Link link, String string, String string2, String string3) {
        this.link = link;
        this.actionId = link.getName();
        this.linkUniqueId = link.getUniqueId();
        this.oldName = string;
        this.newName = string2;
        Common.log("Action: " + string3 + " - link name edit - link: " + link.getName() + " - old: " + string + " new: " + string2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.link.setName(this.oldName);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.link.setName(this.newName);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.link = (Link)hashMap.get(this.linkUniqueId);
        if (this.link == null) {
            this.link = company.getLinkForUniqueId(this.linkUniqueId);
            hashMap.put(this.linkUniqueId, this.link);
        }
    }

    @Override
    public void serialize() {
        this.link = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.link != null) {
            this.link.setName(this.newName);
            return null;
        }
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("link name edit", this.actionId, "Link no longer exists."));
        return vector;
    }
}

