/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Link;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkDeleteEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task task;
    private long taskUniqueId;
    private Link link;
    private long linkUniqueId;
    private int index;
    private String actionId;

    public LinkDeleteEdit(Task task, Link link, int n, String string) {
        this.task = task;
        this.actionId = link.getName();
        this.linkUniqueId = link.getUniqueId();
        this.taskUniqueId = task.getUniqueId();
        this.link = link;
        this.index = n;
        Common.log("Action: " + string + " - link deleted - " + link.getName());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.task.addLinkAt(this.index, this.link);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.task.removeLinkAt(this.index);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.task = (Task)hashMap.get(this.taskUniqueId);
        if (this.task == null) {
            this.task = company.getTaskForUniqueId(this.taskUniqueId);
            hashMap.put(this.taskUniqueId, this.task);
        }
        if (this.task != null) {
            this.index = 0;
            for (Link link : this.task.getLinks()) {
                if (link.getUniqueId() == this.linkUniqueId) {
                    this.link = link;
                }
                ++this.index;
            }
        }
    }

    @Override
    public void serialize() {
        this.link = null;
        this.task = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.link != null) {
            this.task.removeLinkAt(this.index);
            return null;
        }
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        vector.add(new FailedSerializableEdit("link delete", this.actionId, "Link no longer exists."));
        return vector;
    }
}

