/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertEmptyTasksEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task parent;
    private long parentUniqueId;
    private Task child;
    private long childUniqueId;

    public InsertEmptyTasksEdit(Task task, Task task2, String string) {
        this.parent = task;
        this.child = task2;
        this.parentUniqueId = task.getUniqueId();
        this.childUniqueId = task2.getUniqueId();
        Common.log("Action: " + string + " - empty tasks inserted - parent: " + task);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.parent.deleteChild(this.child);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.parent.addChild(this.child, false);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.parent = (Task)hashMap.get(this.parentUniqueId);
        if (this.parent == null) {
            this.parent = company.getTaskForUniqueId(this.parentUniqueId);
            hashMap.put(this.parentUniqueId, this.parent);
        }
        if (this.parent != null) {
            this.child = new Task(this.childUniqueId);
            uniqueIdContainer.newElement(this.child);
            hashMap.put(this.childUniqueId, this.child);
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.parent != null) {
            this.parent.addChild(this.child, false);
        }
        return null;
    }

    @Override
    public void serialize() {
        this.parent = null;
        this.child = null;
    }
}

