/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HResourceEmailEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long uniqueId;
    private HumanResource resource;
    private String oldEmail;
    private String newEmail;

    public HResourceEmailEdit(HumanResource humanResource, String string, String string2, String string3) {
        this.resource = humanResource;
        this.uniqueId = humanResource.getUniqueId();
        this.oldEmail = string;
        this.newEmail = string2;
        Common.log("Action: " + string3 + " - human resource email changed - resource: " + humanResource.getName() + " - old: " + string + " new value: " + string2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.resource.setEmail(this.oldEmail);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.resource.setEmail(this.newEmail);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.resource = (HumanResource)hashMap.get(this.uniqueId);
        if (this.resource == null) {
            this.resource = company.getHumanResourceForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.resource);
        }
    }

    @Override
    public void serialize() {
        this.resource = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.resource != null) {
            this.resource.setEmail(this.newEmail);
        }
        return null;
    }
}

