/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedCompoundEdit
extends CompoundEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Task rescheduleRoot;
    private long rescheduleRootId;

    public static ExtendedCompoundEdit createRescheduleMultipleEdit(Task task) {
        return new ExtendedCompoundEdit(task);
    }

    public static ExtendedCompoundEdit createReschedulSingleEdit(Task task, AbstractUndoableEdit abstractUndoableEdit) {
        ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit(task);
        extendedCompoundEdit.addEdit(abstractUndoableEdit);
        extendedCompoundEdit.end();
        return extendedCompoundEdit;
    }

    public ExtendedCompoundEdit() {
        this.rescheduleRoot = null;
        this.rescheduleRootId = Long.MIN_VALUE;
    }

    private ExtendedCompoundEdit(Task task) {
        this.rescheduleRoot = task;
        assert (task.getCompany() != null);
        this.rescheduleRootId = task.getUniqueId();
    }

    public Vector<UndoableEdit> getEdits() {
        return this.edits;
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        if (this.rescheduleRootId != Long.MIN_VALUE) {
            this.rescheduleRoot = company.getRootTask();
        }
        for (UndoableEdit undoableEdit : this.getEdits()) {
            ((SerializableEdit)((Object)undoableEdit)).deserialize(company, hashMap, uniqueIdContainer);
        }
    }

    @Override
    public void serialize() {
        Vector<UndoableEdit> vector = new Vector<UndoableEdit>();
        for (UndoableEdit undoableEdit : this.getEdits()) {
            if (undoableEdit instanceof SerializableEdit) {
                ((SerializableEdit)((Object)undoableEdit)).serialize();
                continue;
            }
            vector.add(undoableEdit);
        }
        for (UndoableEdit undoableEdit : vector) {
            this.getEdits().removeElement(undoableEdit);
        }
        this.rescheduleRoot = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        Vector<FailedSerializableEdit> vector = new Vector<FailedSerializableEdit>();
        for (UndoableEdit undoableEdit : this.getEdits()) {
            List<FailedSerializableEdit> list = ((SerializableEdit)((Object)undoableEdit)).execute();
            if (list == null) continue;
            vector.addAll(list);
        }
        if (this.rescheduleRoot != null) {
            TaskPlanner.rescheduleTree(this.rescheduleRoot);
        }
        return null;
    }

    @Override
    public void undo() {
        super.undo();
        if (this.rescheduleRoot != null) {
            TaskPlanner.rescheduleTree(this.rescheduleRoot);
        }
    }

    @Override
    public void redo() {
        super.redo();
        if (this.rescheduleRoot != null) {
            TaskPlanner.rescheduleTree(this.rescheduleRoot);
        }
    }

    public void discardReschedule() {
        this.rescheduleRoot = null;
        this.rescheduleRootId = Long.MIN_VALUE;
    }
}

