/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyTypeEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private Dependency dependency;
    private long uniqueId;
    private int oldType;
    private int newType;

    public DependencyTypeEdit(Dependency dependency, int n, int n2, String string) {
        this.dependency = dependency;
        this.uniqueId = dependency.getUniqueId();
        this.oldType = n;
        this.newType = n2;
        Common.log("Action: " + string + " - dependency lag changed - predecessor: " + dependency.getPredecessor() + " - successor: " + dependency.getSuccessor() + " - old: " + n + " new: " + n2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.dependency.setType(this.oldType);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.dependency.setType(this.newType);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.dependency = (Dependency)hashMap.get(this.uniqueId);
        if (this.dependency == null) {
            this.dependency = company.getDependencyForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.dependency);
        }
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        if (this.dependency != null) {
            this.dependency.setType(this.newType);
        }
        return null;
    }

    @Override
    public void serialize() {
        this.dependency = null;
    }
}

