/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.MaterialResource;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteEmptyMaterialResourcesEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private Company company;
    private List<MaterialResource> emptyResources;

    public DeleteEmptyMaterialResourcesEdit(Company company, List<MaterialResource> list, String string) {
        this.company = company;
        this.emptyResources = list;
        Common.log("Action: " + string + " - empty material resources deleted");
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        for (MaterialResource materialResource : this.emptyResources) {
            this.company.addResource(materialResource);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.emptyResources = this.company.removeEmptyMaterialResources();
    }
}

