/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.HumanResource;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteEmptyHumanResourcesEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private Company company;
    private List<HumanResource> emptyResources;

    public DeleteEmptyHumanResourcesEdit(Company company, List<HumanResource> list, int n) {
        this.company = company;
        this.emptyResources = list;
        Common.log("Action: " + n + " - empty human resources deleted");
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        for (HumanResource humanResource : this.emptyResources) {
            this.company.addResource(humanResource);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.emptyResources = this.company.removeEmptyHumanResources();
    }
}

