/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteEmptyClientsEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private Company company;
    private List<Client> emptyClients;

    public DeleteEmptyClientsEdit(Company company, List<Client> list, int n) {
        this.company = company;
        this.emptyClients = list;
        Common.log("Action: " + n + " - empty clients deleted");
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        for (Client client : this.emptyClients) {
            this.company.addClient(client);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.emptyClients = this.company.removeEmptyClients();
    }
}

