/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSiteEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long uniqueId;
    private Client client;
    private String oldSite;
    private String newSite;

    public ClientSiteEdit(Client client, String string, String string2, String string3) {
        this.client = client;
        this.uniqueId = client.getUniqueId();
        this.oldSite = string;
        this.newSite = string2;
        Common.log("Action: " + string3 + " - client site edit - client: " + client.getName() + " - old value: " + string + " new value: " + string2);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.client.setSite(this.oldSite);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.client.setSite(this.newSite);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.client = (Client)hashMap.get(this.uniqueId);
        if (this.client == null) {
            this.client = company.getClientForUniqueId(this.uniqueId);
            hashMap.put(this.uniqueId, this.client);
        }
        if (this.client != null) {
            this.client.setSite(this.newSite);
        }
    }

    @Override
    public void serialize() {
        this.client = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        return null;
    }
}

