/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientNonEmptyEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long uniqueId;
    private Client client;
    private int index;

    public ClientNonEmptyEdit(Client client, int n) {
        this.client = client;
        this.uniqueId = client.getUniqueId();
        this.index = client.getOwner().getClientIndex(client);
        Common.log("Action: " + n + " - client non empty - " + client.getName());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.index = this.client.getOwner().getClientIndex(this.client);
        this.client.revertToEmpty();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.client.getOwner().getClientIndex(this.client) == -1) {
            this.client.getOwner().addClient(this.index, this.client);
        }
    }

    @Override
    public void serialize() {
        this.client = null;
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.client = new Client(this.uniqueId);
        if (this.index > company.getClientsNumber()) {
            this.index = company.getClientsNumber();
        }
        company.addClient(this.index, this.client);
        hashMap.put(this.uniqueId, this.client);
        uniqueIdContainer.newElement(this.client);
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        return null;
    }
}

