/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientInsertEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long uniqueId;
    private Company company;
    private Client client;
    private int index;

    public ClientInsertEdit(Company company, Client client, int n, String string) {
        this.company = company;
        this.client = client;
        this.uniqueId = client.getUniqueId();
        this.index = n;
        Common.log("Action: " + string + " - client inserted - client: " + client.getName());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.company.removeClient(this.client);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.company.addClient(this.index, this.client);
    }

    @Override
    public void serialize() {
        this.client = null;
        this.company = null;
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.company = company;
        this.client = new Client(this.uniqueId);
        if (this.index > company.getClientsNumber()) {
            this.index = company.getClientsNumber();
        }
        company.addClient(this.index, this.client);
        hashMap.put(this.uniqueId, this.client);
        uniqueIdContainer.newElement(this.client);
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        return null;
    }
}

