/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.undo;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.core.UniqueIdContainer;
import com.sbs.jpm.undo.FailedSerializableEdit;
import com.sbs.jpm.undo.SerializableEdit;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarManagerInsertEdit
extends AbstractUndoableEdit
implements SerializableEdit {
    private static final long serialVersionUID = 1L;
    private long uniqueId;
    private Company company;
    private CalendarManager calendar;

    public CalendarManagerInsertEdit(Company company, CalendarManager calendarManager, String string) {
        this.company = company;
        this.calendar = calendarManager;
        this.uniqueId = calendarManager.getUniqueId();
        Common.log("Action: " + string + " - calendar created - " + calendarManager.getName());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.company.removeCalendarManager(this.calendar);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.company.addCalendarManager(this.calendar);
    }

    @Override
    public void deserialize(Company company, HashMap<Long, UniqueId> hashMap, UniqueIdContainer uniqueIdContainer) {
        this.company = company;
        company.addCalendarManager(this.calendar);
        uniqueIdContainer.newElement(this.calendar);
        hashMap.put(this.uniqueId, this.calendar);
    }

    @Override
    public void serialize() {
        this.calendar = (CalendarManager)this.calendar.clone();
        this.calendar.setUniqueId(this.uniqueId);
        this.company = null;
    }

    @Override
    public List<FailedSerializableEdit> execute() {
        return null;
    }
}

