/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.util;

import com.sbs.jpm.ui.treetablechart.util.TextLengthCalculator;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;

public class TextLengthCalculatorImpl
implements TextLengthCalculator {
    private Graphics2D myGraphics;
    private State myState;

    public static int getTextLength(Graphics graphics, String string) {
        if (string.length() == 0) {
            return 0;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = graphics.getFont();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        return (int)rectangle2D.getWidth() + 1;
    }

    public TextLengthCalculatorImpl(Graphics graphics) {
        if (graphics != null) {
            this.setGraphics(graphics);
        }
    }

    public void setGraphics(Graphics graphics) {
        Graphics2D graphics2D;
        this.myGraphics = graphics2D = (Graphics2D)graphics;
        this.myState = null;
    }

    public int getTextLength(String string) {
        return TextLengthCalculatorImpl.getTextLength(this.myGraphics, string);
    }

    public Object getState() {
        if (this.myState == null) {
            this.myState = new State(this.myGraphics.getFontRenderContext(), this.myGraphics.getFont());
        }
        return this.myState;
    }

    static class State {
        Object context;
        Object font;

        State(Object object, Object object2) {
            this.context = object;
            this.font = object2;
            if (object == null) {
                throw new NullPointerException();
            }
            if (object2 == null) {
                throw new NullPointerException();
            }
        }

        public boolean equals(Object object) {
            State state = (State)object;
            if (state == null) {
                return false;
            }
            return state.context.equals(this.context) && state.font.equals(this.font);
        }

        public int hashCode() {
            return this.font.hashCode();
        }
    }
}

