/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.util;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class MultiIcon
implements Icon {
    public static final int ALIGNMENT_HORIZONTAL = 1;
    public static final int ALIGNMENT_VERTICAL = 2;
    public static final int ALIGNMENT_STACKED = 3;
    private int gap = 3;
    private Icon[] icons;
    private int alignment;
    private int width = 0;
    private int height = 0;

    public MultiIcon() {
        this(1);
    }

    public MultiIcon(int n) {
        this.alignment = n;
    }

    public int getIconCount() {
        if (this.icons == null) {
            return 0;
        }
        return this.icons.length;
    }

    public Icon getIconAt(int n) {
        return this.icons[n];
    }

    public void replaceIconAt(int n, Icon icon) {
        this.icons[n] = icon;
        this.width = this.calculateIconWidth();
        this.height = this.calculateIconHeight();
    }

    public void addIcon(Icon icon) {
        if (icon == null) {
            return;
        }
        if (this.icons == null) {
            this.icons = new Icon[]{icon};
        } else {
            Icon[] iconArray = new Icon[this.icons.length + 1];
            System.arraycopy(this.icons, 0, iconArray, 0, this.icons.length);
            iconArray[iconArray.length - 1] = icon;
            this.icons = iconArray;
        }
        this.width = this.calculateIconWidth();
        this.height = this.calculateIconHeight();
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.icons == null) {
            return;
        }
        if (this.alignment == 2) {
            int n3 = n2;
            for (int i = 0; i < this.icons.length; ++i) {
                Icon icon = this.icons[i];
                int n4 = n + (this.width - icon.getIconWidth()) / 2;
                icon.paintIcon(component, graphics, n4, n3);
                n3 += icon.getIconHeight() + this.gap;
            }
        } else if (this.alignment == 3) {
            for (int i = 0; i < this.icons.length; ++i) {
                Icon icon = this.icons[i];
                int n5 = n + (this.width - icon.getIconWidth()) / 2;
                int n6 = n2 + (this.width - icon.getIconHeight()) / 2;
                icon.paintIcon(component, graphics, n5, n6);
            }
        } else {
            assert (this.alignment == 1);
            int n7 = n;
            for (int i = 0; i < this.icons.length; ++i) {
                Icon icon = this.icons[i];
                int n8 = n2 + (this.height - icon.getIconHeight()) / 2;
                icon.paintIcon(component, graphics, n7, n8);
                n7 += icon.getIconWidth() + this.gap;
            }
        }
    }

    public int calculateIconWidth() {
        if (this.icons == null) {
            return 0;
        }
        if (this.alignment == 1) {
            int n = 0;
            for (int i = 0; i < this.icons.length; ++i) {
                n += this.icons[i].getIconWidth();
            }
            return n += this.gap * (this.icons.length - 1);
        }
        int n = 0;
        for (int i = 0; i < this.icons.length; ++i) {
            n = Math.max(n, this.icons[i].getIconHeight());
        }
        return n;
    }

    public int calculateIconHeight() {
        if (this.icons == null) {
            return 0;
        }
        if (this.alignment == 2) {
            int n = 0;
            for (int i = 0; i < this.icons.length; ++i) {
                n += this.icons[i].getIconWidth();
            }
            return n += this.gap * (this.icons.length - 1);
        }
        int n = 0;
        for (int i = 0; i < this.icons.length; ++i) {
            n = Math.max(n, this.icons[i].getIconHeight());
        }
        return n;
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }
}

