/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time.renderer;

import com.sbs.jpm.Common;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.renderer.AbstractTimeScaleRenderer;
import com.sbs.jpm.ui.treetablechart.time.textFormatter.YearNumberTextFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class YearScaleRenderer
extends AbstractTimeScaleRenderer {
    private static final Calendar calendar = Calendar.getInstance();

    public YearScaleRenderer() {
        this(1);
    }

    public YearScaleRenderer(int n) {
        super(n);
        this.currentTextFormatter = new YearNumberTextFormatter(40, 50);
        this.friendlyName = n + " " + Common.I18N_RP.getString("years");
    }

    public long getApproximateUnitDuration() {
        return 31536000000L * (long)this.multiplier;
    }

    protected List getTimeUnits(TimeFrame timeFrame, boolean bl) {
        LinkedList<Date> linkedList = new LinkedList<Date>();
        Date date = timeFrame.getStartDate();
        do {
            linkedList.add(date);
            calendar.setTime(date);
            calendar.set(calendar.get(1), 0, 1, 0, 0, 0);
            calendar.set(14, 0);
            calendar.add(1, this.multiplier);
        } while ((date = calendar.getTime()).before(timeFrame.getEndDate()));
        Date date2 = date;
        linkedList.add(timeFrame.getEndDate());
        if (bl) {
            linkedList.set(linkedList.size() - 1, date2);
        }
        return linkedList;
    }
}

