/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time.renderer;

import com.sbs.jpm.Common;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.renderer.AbstractTimeScaleRenderer;
import com.sbs.jpm.ui.treetablechart.time.textFormatter.DayShortTextFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class DayScaleRenderer
extends AbstractTimeScaleRenderer {
    private static final Calendar calendar = Calendar.getInstance();

    public DayScaleRenderer() {
        this(1);
    }

    public DayScaleRenderer(int n) {
        super(n);
        this.currentTextFormatter = new DayShortTextFormatter(22, 25);
        this.friendlyName = n + " " + Common.I18N_RP.getString("days");
    }

    public long getApproximateUnitDuration() {
        return 86400000L * (long)this.multiplier;
    }

    protected List getTimeUnits(TimeFrame timeFrame, boolean bl) {
        LinkedList<Date> linkedList = new LinkedList<Date>();
        Date date = timeFrame.getStartDate();
        linkedList.add(date);
        calendar.setTime(date);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        int n = calendar.get(6);
        int n2 = n / this.multiplier;
        int n3 = n2 * this.multiplier;
        calendar.set(6, n3);
        Date date2 = calendar.getTime();
        calendar.add(5, this.multiplier);
        date = calendar.getTime();
        while (date.before(timeFrame.getEndDate())) {
            linkedList.add(date);
            calendar.setTime(date);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            calendar.set(14, 0);
            calendar.add(5, this.multiplier);
            date = calendar.getTime();
        }
        Date date3 = date;
        linkedList.add(timeFrame.getEndDate());
        if (bl) {
            linkedList.set(0, date2);
            linkedList.set(linkedList.size() - 1, date3);
        }
        return linkedList;
    }
}

