/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time.renderer;

import com.sbs.jpm.ui.treetablechart.chart.GraphicPrimitiveContainer;
import com.sbs.jpm.ui.treetablechart.chart.PrimitiveStyle;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.renderer.TimeScaleRenderer;
import com.sbs.jpm.ui.treetablechart.time.textFormatter.TextFormatter;
import java.util.Date;
import java.util.List;

public abstract class AbstractTimeScaleRenderer
implements TimeScaleRenderer {
    protected TextFormatter currentTextFormatter;
    protected final int multiplier;
    protected int height = 20;
    protected int[] widthBounderies;
    protected String friendlyName;

    protected AbstractTimeScaleRenderer() {
        this(1);
    }

    protected AbstractTimeScaleRenderer(int n) {
        this.multiplier = n;
    }

    public String setName(String string) {
        this.friendlyName = string;
        return this.friendlyName;
    }

    public String getName() {
        return this.friendlyName;
    }

    public Date[] getTimeUnits(TimeFrame timeFrame) {
        List list = this.getTimeUnits(timeFrame, false);
        Date[] dateArray = new Date[list.size()];
        list.toArray(dateArray);
        return dateArray;
    }

    public Date[] getExtendedTimeUnits(TimeFrame timeFrame) {
        List list = this.getTimeUnits(timeFrame, true);
        Date[] dateArray = new Date[list.size()];
        list.toArray(dateArray);
        return dateArray;
    }

    protected abstract List getTimeUnits(TimeFrame var1, boolean var2);

    public int getMultiplier() {
        return this.multiplier;
    }

    private void render(TextFormatter textFormatter, TimeScaleManager timeScaleManager, TimeFrame timeFrame, Date[] dateArray, GraphicPrimitiveContainer graphicPrimitiveContainer, int n, int n2, int n3) {
        double d = timeScaleManager.getWidth(timeFrame);
        double[] dArray = this.computeFramesWidth(timeFrame, timeScaleManager, dateArray);
        GraphicPrimitiveContainer.Rectangle rectangle = graphicPrimitiveContainer.createRectangle(n, n2, d, n3);
        rectangle.setStyle(PrimitiveStyle.TIMESCALE_BACKGROUND);
        for (int i = 0; i < dArray.length; ++i) {
            GraphicPrimitiveContainer.Line line = graphicPrimitiveContainer.createLine((double)n + dArray[i], n2, (double)n + dArray[i], n2 + n3, true);
            line.setStyle(PrimitiveStyle.TIMESCALE_UNIT_DELIMITER);
            String string = textFormatter.getText(dateArray[i]);
            int n4 = n + 3;
            int n5 = n2 + n3 - 5;
            if (i == 0) continue;
            graphicPrimitiveContainer.createText((double)n4 + dArray[i - 1], n2, (double)n4 + dArray[i], n5, string);
        }
        GraphicPrimitiveContainer.Line line = graphicPrimitiveContainer.createLine(n, n2 + n3 - 1, d, n2 + n3 - 1);
        line.setStyle(PrimitiveStyle.TIMESCALE_UNIT_DELIMITER);
    }

    private double[] computeFramesWidth(TimeFrame timeFrame, TimeScaleManager timeScaleManager, Date[] dateArray) {
        double d = timeScaleManager.getPixelDuration();
        double[] dArray = new double[dateArray.length - 1];
        for (int i = 1; i < dateArray.length; ++i) {
            long l = dateArray[i].getTime() - timeFrame.getStartDate().getTime();
            dArray[i - 1] = (int)((double)l / d);
        }
        return dArray;
    }

    public void render(TimeFrame timeFrame, TimeScaleManager timeScaleManager, GraphicPrimitiveContainer graphicPrimitiveContainer, int n, int n2) {
        TimeFrame timeFrame2 = new TimeFrame(new Date(timeFrame.getStartDate().getTime() - this.getApproximateUnitDuration()), new Date(timeFrame.getEndDate().getTime() + this.getApproximateUnitDuration()));
        this.render(this.currentTextFormatter, timeScaleManager, timeFrame, this.getTimeUnits(timeFrame2), graphicPrimitiveContainer, n, n2, this.height);
    }

    public void setTextFormatter(TextFormatter textFormatter) {
        this.currentTextFormatter = textFormatter;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPrefferedWidth() {
        return this.currentTextFormatter.getPrefferedWidth();
    }

    public int getMinWidth() {
        return this.currentTextFormatter.getMinWidth();
    }
}

