/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time;

import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.ui.treetablechart.JResourceChart;
import com.sbs.jpm.ui.treetablechart.JResourceTreeTable;
import com.sbs.jpm.ui.treetablechart.ResourceSheetHighlighter;
import com.sbs.jpm.ui.treetablechart.chart.GraphicPrimitiveContainer;
import com.sbs.jpm.ui.treetablechart.chart.Painter;
import com.sbs.jpm.ui.treetablechart.chart.PrimitiveStyle;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.TreeTableManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import javax.swing.tree.TreePath;

public class WorkTreeTableManager
extends TreeTableManager {
    private FontMetrics fm;

    public WorkTreeTableManager(JResourceTreeTable jResourceTreeTable, TimeScaleManager timeScaleManager) {
        super(jResourceTreeTable, timeScaleManager);
    }

    private void displayWork(long l, double d, double d2, double d3, double d4, Color color, Font font) {
        Formatter formatter = new Formatter();
        formatter.format("%.2f", (double)l / (double)this.treeTable.getProject().getDurationManager().getDuration(DurationManager.HOUR));
        String string = formatter.toString() + DurationManager.HOUR;
        int n = this.fm.stringWidth(string);
        if (n > this.timeScaleManager.getCurrentBottomUnitSize() - 5) {
            int n2;
            String string2 = "...";
            int n3 = this.fm.stringWidth(string2);
            for (n2 = 0; n2 < string.length() && (n3 += this.fm.charWidth(string.charAt(n2))) <= this.timeScaleManager.getCurrentBottomUnitSize() - 5; ++n2) {
            }
            string = string.substring(0, n2) + string2;
        }
        double d5 = d + 3.0;
        double d6 = d4 - 5.0;
        GraphicPrimitiveContainer.Text text = this.graphicPrimitiveContainer.createText(d5, d2, d3, d6, string);
        text.setStyle(PrimitiveStyle.TREETABLE_TEXT);
        text.setForegroundColor(color);
        text.setFont(font);
    }

    private void displayUnits(double d, double d2, double d3, double d4, double d5, Font font) {
        Formatter formatter = new Formatter();
        formatter.format("%.2f", d);
        String string = formatter.toString();
        int n = this.fm.stringWidth(string);
        if (n > this.timeScaleManager.getCurrentBottomUnitSize() - 5) {
            int n2;
            String string2 = "...";
            int n3 = this.fm.stringWidth(string2);
            for (n2 = 0; n2 < string.length() && (n3 += this.fm.charWidth(string.charAt(n2))) <= this.timeScaleManager.getCurrentBottomUnitSize() - 5; ++n2) {
            }
            string = string.substring(0, n2) + string2;
        }
        double d6 = d2 + 3.0;
        double d7 = d5 - 5.0;
        GraphicPrimitiveContainer.Text text = this.graphicPrimitiveContainer.createText(d6, d3, d4, d7, string);
        text.setStyle(PrimitiveStyle.TREETABLE_TEXT);
        text.setFont(font);
    }

    public void paint(Painter painter, Graphics graphics, int n) {
        Rectangle rectangle = graphics.getClipBounds();
        TimeFrame timeFrame = new TimeFrame(new Date(this.timeScaleManager.getMilis(rectangle.x)), new Date(this.timeScaleManager.getMilis(rectangle.x + rectangle.width)));
        this.render(timeFrame, graphics);
        this.graphicPrimitiveContainer.paint(painter, graphics);
    }

    protected void render(TimeFrame timeFrame, Graphics graphics) {
        this.fm = this.treeTable.getGraphics().getFontMetrics();
        Rectangle rectangle = graphics.getClipBounds();
        this.graphicPrimitiveContainer.clear();
        int n = this.treeTable.getRowHeight();
        List<Integer> list = ((JResourceChart)this.treeTable.getTreeTableChart()).getResourceSheetData().getWorkDataList();
        int n2 = list.size();
        int n3 = n2 != 0 ? n / n2 : 18;
        int n4 = this.treeTable.getRowForPath(this.treeTable.getPathForLocation(1, rectangle.y));
        int n5 = this.treeTable.getRowForPath(this.treeTable.getPathForLocation(1, rectangle.y + rectangle.height)) - 1;
        Date[] dateArray = this.timeScaleManager.getCurrentScaleCombination().getBottomRenderer().getExtendedTimeUnits(timeFrame);
        Font font = this.treeTable.getFont();
        for (int i = 0; i < dateArray.length - 1; ++i) {
            double d = this.timeScaleManager.getX(dateArray[i].getTime());
            double d2 = this.timeScaleManager.getX(dateArray[i + 1].getTime());
            int n6 = this.timeScaleManager.getCurrentScaleCombination().getBottomRenderer().getMinWidth();
            double d3 = this.timeScaleManager.convertMilisToPixels(dateArray[1].getTime() - dateArray[0].getTime());
            if (i == 0 && (double)n6 > d3) continue;
            boolean bl = false;
            for (int j = n4; j <= n5; ++j) {
                long l;
                long l2;
                long l3;
                long l4;
                long l5;
                int n7;
                int n8;
                UniqueId uniqueId;
                TreePath treePath = this.treeTable.getPathForRow(j);
                Object object = treePath.getLastPathComponent();
                if (object instanceof Assignment) {
                    uniqueId = (Assignment)object;
                    Resource resource = ((Assignment)uniqueId).getResource();
                    n8 = j * n;
                    n7 = j * n - n3;
                    block43: for (int k = 0; k < n2; ++k) {
                        Resource resource2;
                        n7 += n3;
                        n8 += n3;
                        if (resource instanceof HumanResource) {
                            resource2 = (HumanResource)resource;
                            if (!bl) {
                                ((Assignment)uniqueId).computeWork(dateArray[i], dateArray[i + 1], ((Assignment)uniqueId).getTask().getCompletionDate());
                            }
                            l5 = ((HumanResource)resource2).getOvertimeWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                            l4 = ((HumanResource)resource2).getStandardWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                            l3 = l4 + l5;
                            l2 = ((HumanResource)resource2).getActualWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                            l = ((HumanResource)resource2).getRemainingWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                            boolean bl2 = ((HumanResource)resource2).isOverallocated((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                            boolean bl3 = l5 != 0L;
                            switch (list.get(k)) {
                                case 0: {
                                    if (l2 == 0L) break;
                                    if (bl2) {
                                        this.displayWork(l2, d, n7, d2, n8, ResourceSheetHighlighter.OVERALOCATED_COLOR, font);
                                        break;
                                    }
                                    if (bl3) {
                                        this.displayWork(l2, d, n7, d2, n8, ResourceSheetHighlighter.OVERTIME_COLOR, font);
                                        break;
                                    }
                                    this.displayWork(l2, d, n7, d2, n8, Color.BLACK, font);
                                    break;
                                }
                                case 1: {
                                    if (l == 0L) break;
                                    if (bl2) {
                                        this.displayWork(l, d, n7, d2, n8, ResourceSheetHighlighter.OVERALOCATED_COLOR, font);
                                        break;
                                    }
                                    if (bl3) {
                                        this.displayWork(l, d, n7, d2, n8, ResourceSheetHighlighter.OVERTIME_COLOR, font);
                                        break;
                                    }
                                    this.displayWork(l, d, n7, d2, n8, Color.BLACK, font);
                                    break;
                                }
                                case 2: {
                                    if (l3 == 0L) break;
                                    if (bl2) {
                                        this.displayWork(l3, d, n7, d2, n8, ResourceSheetHighlighter.OVERALOCATED_COLOR, font);
                                        break;
                                    }
                                    if (bl3) {
                                        this.displayWork(l3, d, n7, d2, n8, ResourceSheetHighlighter.OVERTIME_COLOR, font);
                                        break;
                                    }
                                    this.displayWork(l3, d, n7, d2, n8, Color.BLACK, font);
                                    break;
                                }
                                case 3: {
                                    if (l4 == 0L) break;
                                    if (bl2) {
                                        this.displayWork(l4, d, n7, d2, n8, ResourceSheetHighlighter.OVERALOCATED_COLOR, font);
                                        break;
                                    }
                                    if (bl3) {
                                        this.displayWork(l4, d, n7, d2, n8, ResourceSheetHighlighter.OVERTIME_COLOR, font);
                                        break;
                                    }
                                    this.displayWork(l4, d, n7, d2, n8, Color.BLACK, font);
                                    break;
                                }
                                case 4: {
                                    if (l5 == 0L) break;
                                    if (bl2) {
                                        this.displayWork(l5, d, n7, d2, n8, ResourceSheetHighlighter.OVERALOCATED_COLOR, font);
                                        break;
                                    }
                                    if (bl3) {
                                        this.displayWork(l5, d, n7, d2, n8, ResourceSheetHighlighter.OVERTIME_COLOR, font);
                                        break;
                                    }
                                    this.displayWork(l5, d, n7, d2, n8, Color.BLACK, font);
                                    break;
                                }
                                case 5: {
                                    break;
                                }
                                case 6: {
                                    break;
                                }
                                case 7: {
                                    break;
                                }
                            }
                            continue;
                        }
                        resource2 = (MaterialResource)resource;
                        switch (list.get(k)) {
                            case 0: {
                                double d4 = ((MaterialResource)resource2).getActualUnits((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                                if (d4 == -1.0) continue block43;
                                this.displayUnits(d4, d, n7, d2, n8, font);
                                continue block43;
                            }
                            case 1: {
                                double d5 = ((MaterialResource)resource2).getRemainingUnits((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                                if (d5 == -1.0) continue block43;
                                this.displayUnits(d5, d, n7, d2, n8, font);
                                continue block43;
                            }
                            case 2: {
                                double d6 = ((MaterialResource)resource2).getUnits((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                                if (d6 == -1.0) continue block43;
                                this.displayUnits(d6, d, n7, d2, n8, font);
                                continue block43;
                            }
                            case 3: {
                                continue block43;
                            }
                            case 4: {
                                continue block43;
                            }
                            case 5: {
                                continue block43;
                            }
                            case 6: {
                                continue block43;
                            }
                            case 7: {
                                continue block43;
                            }
                        }
                    }
                    continue;
                }
                if (!(object instanceof Resource) || ((Resource)(uniqueId = (Resource)object)).isEmpty()) continue;
                int n9 = j * n;
                n8 = j * n - n3;
                if (uniqueId instanceof HumanResource) {
                    bl = true;
                    HumanResource humanResource = (HumanResource)uniqueId;
                    humanResource.computeWork(dateArray[i], dateArray[i + 1]);
                    long l6 = humanResource.getOvertimeWork(dateArray[i], dateArray[i + 1]);
                    l5 = humanResource.getOverallocatedWork(dateArray[i], dateArray[i + 1]);
                    l4 = humanResource.getStandardWork(dateArray[i], dateArray[i + 1]);
                    l3 = humanResource.getActualWork(dateArray[i], dateArray[i + 1]);
                    l2 = humanResource.getRemainingWork(dateArray[i], dateArray[i + 1]);
                    l = humanResource.getUsedWork(dateArray[i], dateArray[i + 1]);
                    long l7 = humanResource.getAvailableWork(dateArray[i], dateArray[i + 1]);
                    long l8 = humanResource.getCapacityWork(dateArray[i], dateArray[i + 1]);
                    long l9 = l4 + l6;
                    boolean bl4 = humanResource.isOverallocated(dateArray[i], dateArray[i + 1]);
                    boolean bl5 = l6 != 0L;
                    block44: for (int k = 0; k < n2; ++k) {
                        n8 += n3;
                        n9 += n3;
                        switch (list.get(k)) {
                            case 0: {
                                if (l3 == 0L) continue block44;
                                if (bl4) {
                                    this.displayWork(l3, d, n8, d2, n9, ResourceSheetHighlighter.OVERALOCATED_COLOR, font.deriveFont(1));
                                    continue block44;
                                }
                                if (bl5) {
                                    this.displayWork(l3, d, n8, d2, n9, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                                    continue block44;
                                }
                                this.displayWork(l3, d, n8, d2, n9, Color.BLACK, font.deriveFont(1));
                                continue block44;
                            }
                            case 1: {
                                if (l2 == 0L) continue block44;
                                if (bl4) {
                                    this.displayWork(l2, d, n8, d2, n9, ResourceSheetHighlighter.OVERALOCATED_COLOR, font.deriveFont(1));
                                    continue block44;
                                }
                                if (bl5) {
                                    this.displayWork(l2, d, n8, d2, n9, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                                    continue block44;
                                }
                                this.displayWork(l2, d, n8, d2, n9, Color.BLACK, font.deriveFont(1));
                                continue block44;
                            }
                            case 2: {
                                if (l9 == 0L) continue block44;
                                if (bl4) {
                                    this.displayWork(l9, d, n8, d2, n9, ResourceSheetHighlighter.OVERALOCATED_COLOR, font.deriveFont(1));
                                    continue block44;
                                }
                                if (bl5) {
                                    this.displayWork(l9, d, n8, d2, n9, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                                    continue block44;
                                }
                                this.displayWork(l9, d, n8, d2, n9, Color.BLACK, font.deriveFont(1));
                                continue block44;
                            }
                            case 3: {
                                if (l4 == 0L) continue block44;
                                this.displayWork(l4, d, n8, d2, n9, Color.BLACK, font.deriveFont(1));
                                continue block44;
                            }
                            case 4: {
                                if (l6 == 0L) continue block44;
                                this.displayWork(l6, d, n8, d2, n9, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                                continue block44;
                            }
                            case 5: {
                                if (l5 == 0L) continue block44;
                                if (bl4) {
                                    this.displayWork(l5, d, n8, d2, n9, ResourceSheetHighlighter.OVERALOCATED_COLOR, font.deriveFont(1));
                                    continue block44;
                                }
                                if (bl5) {
                                    this.displayWork(l5, d, n8, d2, n9, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                                    continue block44;
                                }
                                this.displayWork(l5, d, n8, d2, n9, Color.BLACK, font.deriveFont(1));
                                continue block44;
                            }
                            case 6: {
                                if (l == 0L) continue block44;
                                if (bl4) {
                                    this.displayWork(l, d, n8, d2, n9, ResourceSheetHighlighter.OVERALOCATED_COLOR, font.deriveFont(1));
                                    continue block44;
                                }
                                if (l6 != 0L) {
                                    this.displayWork(l, d, n8, d2, n9, ResourceSheetHighlighter.OVERTIME_COLOR, font.deriveFont(1));
                                    continue block44;
                                }
                                this.displayWork(l, d, n8, d2, n9, Color.BLACK, font.deriveFont(1));
                                continue block44;
                            }
                            case 7: {
                                if (l7 == 0L) continue block44;
                                this.displayWork(l7, d, n8, d2, n9, Color.GREEN.darker().darker(), font.deriveFont(1));
                                continue block44;
                            }
                            case 8: {
                                if (l8 == 0L) continue block44;
                                this.displayWork(l8, d, n8, d2, n9, Color.BLACK, font.deriveFont(1));
                            }
                        }
                    }
                    continue;
                }
                block45: for (n7 = 0; n7 < n2; ++n7) {
                    n9 += n3;
                    MaterialResource materialResource = (MaterialResource)uniqueId;
                    switch (list.get(n7)) {
                        case 0: {
                            double d7 = materialResource.getActualUnits(dateArray[i], dateArray[i + 1]);
                            if (d7 == -1.0) continue block45;
                            this.displayUnits(d7, d, n8, d2, n9, font);
                            continue block45;
                        }
                        case 1: {
                            double d7 = materialResource.getRemainingUnits(dateArray[i], dateArray[i + 1]);
                            if (d7 == -1.0) continue block45;
                            this.displayUnits(d7, d, n8, d2, n9, font);
                            continue block45;
                        }
                        case 2: {
                            double d7 = materialResource.getTotalUnits(dateArray[i], dateArray[i + 1]);
                            if (d7 == -1.0) continue block45;
                            this.displayUnits(d7, d, n8, d2, n9, font);
                            continue block45;
                        }
                        case 3: {
                            continue block45;
                        }
                        case 4: {
                            continue block45;
                        }
                        case 5: {
                            continue block45;
                        }
                        case 6: {
                            continue block45;
                        }
                        case 7: {
                            continue block45;
                        }
                    }
                }
            }
        }
    }
}

