/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time;

import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.UniqueId;
import com.sbs.jpm.ui.treetablechart.JResourceTreeTable;
import com.sbs.jpm.ui.treetablechart.chart.GraphicPrimitiveContainer;
import com.sbs.jpm.ui.treetablechart.chart.PrimitiveStyle;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.TreeTableManager;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Date;
import javax.swing.tree.TreePath;

public class ProjectsTreeTableManager
extends TreeTableManager {
    private FontMetrics fm;

    public ProjectsTreeTableManager(JResourceTreeTable jResourceTreeTable, TimeScaleManager timeScaleManager) {
        super(jResourceTreeTable, timeScaleManager);
    }

    private void displayProjects(String string, double d, double d2, double d3, double d4, Font font) {
        int n = this.fm.stringWidth(string);
        if (n > this.timeScaleManager.getCurrentBottomUnitSize() - 5) {
            int n2;
            String string2 = "...";
            int n3 = this.fm.stringWidth(string2);
            for (n2 = 0; n2 < string.length() && (n3 += this.fm.charWidth(string.charAt(n2))) <= this.timeScaleManager.getCurrentBottomUnitSize() - 5; ++n2) {
            }
            string = string.substring(0, n2) + string2;
        }
        double d5 = d + 3.0;
        double d6 = d4 - 5.0;
        GraphicPrimitiveContainer.Text text = this.graphicPrimitiveContainer.createText(d5, d2, d3, d6, string);
        text.setStyle(PrimitiveStyle.TREETABLE_TEXT);
        text.setFont(font);
    }

    protected void render(TimeFrame timeFrame, Graphics graphics) {
        this.fm = this.treeTable.getGraphics().getFontMetrics();
        this.graphicPrimitiveContainer.clear();
        int n = this.treeTable.getRowHeight();
        int n2 = 0;
        int n3 = this.treeTable.getRowCount() - 1;
        Date[] dateArray = this.timeScaleManager.getCurrentScaleCombination().getBottomRenderer().getExtendedTimeUnits(timeFrame);
        Font font = this.treeTable.getFont();
        for (int i = 0; i < dateArray.length - 1; ++i) {
            double d = this.timeScaleManager.getX(dateArray[i].getTime());
            double d2 = this.timeScaleManager.getX(dateArray[i + 1].getTime());
            int n4 = this.timeScaleManager.getCurrentScaleCombination().getBottomRenderer().getMinWidth();
            double d3 = this.timeScaleManager.convertMilisToPixels(dateArray[1].getTime() - dateArray[0].getTime());
            if (i == 0 && (double)n4 > d3) continue;
            boolean bl = false;
            for (int j = n2; j <= n3; ++j) {
                long l;
                long l2;
                UniqueId uniqueId;
                TreePath treePath = this.treeTable.getPathForRow(j);
                Object object = treePath.getLastPathComponent();
                if (object instanceof Assignment) {
                    uniqueId = (Assignment)object;
                    Task task = ((Assignment)uniqueId).getTask();
                    Resource resource = ((Assignment)uniqueId).getResource();
                    int n5 = (j + 1) * n;
                    int n6 = j * n;
                    if (resource instanceof HumanResource) {
                        HumanResource humanResource = (HumanResource)resource;
                        if (!bl) {
                            ((Assignment)uniqueId).computeWork(dateArray[i], dateArray[i + 1], ((Assignment)uniqueId).getTask().getCompletionDate());
                        }
                        l2 = humanResource.getOvertimeWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                        l = humanResource.getStandardWork((Assignment)uniqueId, dateArray[i], dateArray[i + 1]);
                        long l3 = l + l2;
                        if (l3 == 0L) continue;
                        this.displayProjects(task.getProjectTask().getName(), d, n6, d2, n5, font);
                        continue;
                    }
                    double d4 = (double)task.getWorkingDuration(dateArray[i], dateArray[i + 1]) * ((Assignment)uniqueId).getUnits();
                    if (task.isMilestone()) {
                        Date date = task.getStartDate();
                        if (date.before(dateArray[i]) || !date.before(dateArray[i + 1])) continue;
                        this.displayProjects(task.getProjectTask().getName(), d, n6, d2, n5, font);
                        continue;
                    }
                    if (d4 == 0.0) continue;
                    d4 /= (double)task.getWorkingDuration();
                    this.displayProjects(task.getProjectTask().getName(), d, n6, d2, n5, font);
                    continue;
                }
                if (!(object instanceof Resource) || ((Resource)(uniqueId = (Resource)object)).isEmpty()) continue;
                int n7 = (j + 1) * n;
                int n8 = j * n;
                if (uniqueId instanceof HumanResource) {
                    bl = true;
                    HumanResource humanResource = (HumanResource)uniqueId;
                    humanResource.computeWork(dateArray[i], dateArray[i + 1]);
                    long l4 = humanResource.getOvertimeWork(dateArray[i], dateArray[i + 1]);
                    l2 = humanResource.getStandardWork(dateArray[i], dateArray[i + 1]);
                    l = l2 + l4;
                    if (l == 0L) continue;
                    this.displayProjects(humanResource.getProjects(dateArray[i], dateArray[i + 1]), d, n8, d2, n7, font.deriveFont(1));
                    continue;
                }
                this.displayProjects(((MaterialResource)uniqueId).getProjects(dateArray[i], dateArray[i + 1]), d, n8, d2, n7, font.deriveFont(1));
            }
        }
    }
}

