/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.time;

import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.baseline.Baseline;
import com.sbs.jpm.core.baseline.BaselineManager;
import com.sbs.jpm.core.baseline.BaselineManagerAdapter;
import com.sbs.jpm.core.baseline.BaselineManagerEvent;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.component.util.TaskDurationFormat;
import com.sbs.jpm.ui.component.util.TaskWorkDurationFormat;
import com.sbs.jpm.ui.treetablechart.JGanttTreeTable;
import com.sbs.jpm.ui.treetablechart.chart.GraphicPrimitiveContainer;
import com.sbs.jpm.ui.treetablechart.chart.PrimitiveStyle;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.TreeTableManager;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreePath;

public class GanttTreeTableManager
extends TreeTableManager {
    private static final double TOP_OFFSET = 3.0;
    private static final double completionBarRation = 0.4;
    private Calendar calendar;
    private Icon deadlineIcon = new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/deadline.png"));
    private Icon highlightedDeadlineIcon = new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/deadlineHighlighted.png"));

    public GanttTreeTableManager(JGanttTreeTable jGanttTreeTable, TimeScaleManager timeScaleManager) {
        super(jGanttTreeTable, timeScaleManager);
        this.calendar = Calendar.getInstance();
        BaselineManager.getInstance().addBaselineManagerListener(new BaselineManagerAdapter(){

            public void baselineShown(BaselineManagerEvent baselineManagerEvent) {
                GanttTreeTableManager.this.graphicPrimitiveContainer.setDirty(true);
            }

            public void baselineHidden(BaselineManagerEvent baselineManagerEvent) {
                GanttTreeTableManager.this.graphicPrimitiveContainer.setDirty(true);
            }
        });
    }

    private long getConventionalDate(long l, boolean bl, CalendarManager calendarManager) {
        long l2;
        long l3;
        this.calendar.setTimeInMillis(l);
        if (bl) {
            l3 = CalendarManager.getDayStartTime(this.calendar);
            l2 = calendarManager.getDuration(new Date(l3), new Date(l), true);
        } else {
            this.calendar.add(5, 1);
            l3 = CalendarManager.getDayStartTime(this.calendar);
            l2 = calendarManager.getDuration(new Date(l), new Date(l3), true);
        }
        if (l2 == 0L) {
            return l3;
        }
        return l;
    }

    protected void render(TimeFrame timeFrame, Graphics graphics) {
        Object object;
        Object object2;
        this.graphicPrimitiveContainer.clear();
        boolean bl = !this.calendaristic && this.timeScaleManager.getCurrentScaleCombination().getApproximateUnitDuration() >= 86400000L;
        int n = this.treeTable.getRowHeight();
        UIManager uIManager = UIManager.getInstance();
        int n2 = 0;
        int n3 = this.treeTable.getRowCount() - 1;
        for (int i = n2; i <= n3; ++i) {
            StringBuffer stringBuffer;
            Object object3;
            int n4;
            Object object4;
            Object object5;
            Object object6;
            Object object8;
            Object object9;
            TreePath treePath = this.treeTable.getPathForRow(i);
            Task task = (Task)treePath.getLastPathComponent();
            if (task.isEmpty()) continue;
            object2 = BaselineManager.getInstance();
            int n5 = task.isLeaf() && !task.isProject() && ((BaselineManager)object2).isShowBaseline() ? (int)(((double)n - 6.0) / 2.0) : (int)((double)n - 6.0);
            double d = task.getStartDate().getTime();
            double d2 = task.getEndDate().getTime();
            double d3 = task.getCompletionDate().getTime();
            CalendarManager calendarManager = task.getUsedCalendar();
            if (bl) {
                d = this.getConventionalDate((long)d, true, calendarManager);
                d2 = this.getConventionalDate((long)d2, false, calendarManager);
                d3 = task.getCompletion() == 0.0 ? d : (double)this.getConventionalDate((long)d3, false, calendarManager);
            }
            double d4 = this.timeScaleManager.getX((long)d);
            double d5 = this.timeScaleManager.getX((long)d2);
            double d6 = this.timeScaleManager.getX((long)d3);
            int n6 = (int)((double)(i * n) + 3.0);
            if (task.isLeaf() && !task.isProject() && ((BaselineManager)object2).isShowBaseline()) {
                int n7 = 0;
                object9 = task.getBaselineAt(BaselineManager.getInstance().getVisibleBaseline());
                if (object9 != null) {
                    double d7 = ((Baseline)object9).getStartDate().getTime();
                    double d8 = ((Baseline)object9).getEndDate().getTime();
                    double d9 = ((Baseline)object9).getCompletionDate().getTime();
                    if (bl) {
                        d7 = this.getConventionalDate((long)d7, true, calendarManager);
                        d8 = this.getConventionalDate((long)d8, false, calendarManager);
                        d9 = ((Baseline)object9).getCompletion() == 0.0 ? d7 : (double)this.getConventionalDate((long)d9, false, calendarManager);
                    }
                    double d10 = this.timeScaleManager.getX((long)d7);
                    double d11 = this.timeScaleManager.getX((long)d8);
                    double d12 = this.timeScaleManager.getX((long)d9);
                    if (task.isMilestone()) {
                        object8 = this.graphicPrimitiveContainer.createRectangle(d10, n6 + n5 * (n7 + 1), 0.0, n5 - 1, true);
                        ((GraphicPrimitiveContainer.GraphicPrimitive)object8).setStyle(PrimitiveStyle.BASELINE);
                    } else {
                        object8 = this.graphicPrimitiveContainer.createRectangle(d10, n6 + n5 * (n7 + 1), d11 - d10, n5 - 1, true);
                        if (task.isProject()) {
                            ((GraphicPrimitiveContainer.GraphicPrimitive)object8).setStyle(PrimitiveStyle.BASELINE);
                        } else if (task.isLeaf()) {
                            int n8 = (int)((double)n5 * 0.4);
                            int n9 = (n5 - n8) / 2;
                            if (n5 > 2 * n9 + n8) {
                                ++n8;
                            }
                            GraphicPrimitiveContainer.Rectangle rectangle = this.graphicPrimitiveContainer.createRectangle(d10, n6 + n5 * (n7 + 1) + n9, d12 - d10, n8, true);
                            rectangle.setModelObject(task);
                            rectangle.setStyle(PrimitiveStyle.BASELINE_COMPLETION);
                            ((GraphicPrimitiveContainer.GraphicPrimitive)object8).setStyle(PrimitiveStyle.BASELINE);
                        } else {
                            ((GraphicPrimitiveContainer.GraphicPrimitive)object8).setStyle(PrimitiveStyle.BASELINE);
                        }
                    }
                    ((GraphicPrimitiveContainer.GraphicPrimitive)object8).setModelObject(task);
                }
                if (task.isMilestone()) {
                    object8 = this.graphicPrimitiveContainer.createRectangle(d4, n6, 0.0, n5 - 1, true);
                    ((GraphicPrimitiveContainer.GraphicPrimitive)object8).setStyle(PrimitiveStyle.MILESTONE);
                } else {
                    object8 = this.graphicPrimitiveContainer.createRectangle(d4, n6, d5 - d4, n5 - 1, true);
                    if (task.isProject()) {
                        ((GraphicPrimitiveContainer.GraphicPrimitive)object8).setStyle(PrimitiveStyle.PROJECT);
                    } else if (task.isLeaf()) {
                        int n10 = (int)((double)n5 * 0.4);
                        int n11 = (n5 - n10) / 2;
                        if (n5 > 2 * n11 + n10) {
                            ++n10;
                        }
                        GraphicPrimitiveContainer.Rectangle rectangle = this.graphicPrimitiveContainer.createRectangle(d4, n6 + n11, d6 - d4, n10, true);
                        rectangle.setModelObject(task);
                        ((GraphicPrimitiveContainer.GraphicPrimitive)object8).setStyle(PrimitiveStyle.TASK);
                        rectangle.setStyle(PrimitiveStyle.TASK_COMPLETION);
                    } else {
                        ((GraphicPrimitiveContainer.GraphicPrimitive)object8).setStyle(PrimitiveStyle.SUPERTASK);
                    }
                }
                ((GraphicPrimitiveContainer.GraphicPrimitive)object8).setModelObject(task);
            } else {
                if (task.isMilestone()) {
                    object6 = this.graphicPrimitiveContainer.createRectangle(d4, n6, 0.0, n5 - 1, true);
                    ((GraphicPrimitiveContainer.GraphicPrimitive)object6).setStyle(PrimitiveStyle.MILESTONE);
                } else {
                    object6 = this.graphicPrimitiveContainer.createRectangle(d4, n6, d5 - d4, n5 - 1, true);
                    if (task.isProject()) {
                        ((GraphicPrimitiveContainer.GraphicPrimitive)object6).setStyle(PrimitiveStyle.PROJECT);
                    } else if (task.isLeaf()) {
                        int n12 = (int)((double)n5 * 0.4);
                        int n13 = (n5 - n12) / 2;
                        if (n5 > 2 * n13 + n12) {
                            ++n12;
                        }
                        object5 = this.graphicPrimitiveContainer.createRectangle(d4, n6 + n13, d6 - d4, n12, true);
                        ((GraphicPrimitiveContainer.GraphicPrimitive)object5).setModelObject(task);
                        ((GraphicPrimitiveContainer.GraphicPrimitive)object5).setStyle(PrimitiveStyle.TASK_COMPLETION);
                        ((GraphicPrimitiveContainer.GraphicPrimitive)object6).setStyle(PrimitiveStyle.TASK);
                    } else if (!task.isSplitted()) {
                        ((GraphicPrimitiveContainer.GraphicPrimitive)object6).setStyle(PrimitiveStyle.SUPERTASK);
                    } else {
                        ((GraphicPrimitiveContainer.GraphicPrimitive)object6).setStyle(PrimitiveStyle.SPLITTED_TASK);
                        object9 = task;
                        for (int j = 0; j < ((Task)object9).getChildNumber(); ++j) {
                            object5 = ((Task)object9).getChildAt(j);
                            double d13 = ((Task)object5).getStartDate().getTime();
                            double d14 = ((Task)object5).getEndDate().getTime();
                            double d15 = ((Task)object5).getCompletionDate().getTime();
                            object4 = ((Task)object5).getUsedCalendar();
                            if (bl) {
                                d13 = this.getConventionalDate((long)d13, true, (CalendarManager)object4);
                                d14 = this.getConventionalDate((long)d14, false, (CalendarManager)object4);
                                d15 = ((Task)object5).getCompletion() == 0.0 ? d13 : (double)this.getConventionalDate((long)d15, false, (CalendarManager)object4);
                            }
                            double d16 = this.timeScaleManager.getX((long)d13);
                            double d17 = this.timeScaleManager.getX((long)d14);
                            double d18 = this.timeScaleManager.getX((long)d15);
                            GraphicPrimitiveContainer.RectangleArrayPart rectangleArrayPart = this.graphicPrimitiveContainer.createRectangleArrayPart(d16, n6, d17 - d16, n5 - 1, true, j);
                            rectangleArrayPart.setModelObject(object5);
                            rectangleArrayPart.setStyle(PrimitiveStyle.SPLITTED_TASK_PART);
                            if (j != 0 && !(((Task)object5).getCompletion() > 0.0)) continue;
                            int n7 = (int)((double)n5 * 0.4);
                            n4 = (n5 - n7) / 2;
                            if (n5 > 2 * n4 + n7) {
                                ++n7;
                            }
                            object3 = this.graphicPrimitiveContainer.createRectangleArrayPart(d16, n6 + n4, d18 - d16, n7, true, j);
                            ((GraphicPrimitiveContainer.GraphicPrimitive)object3).setModelObject(object5);
                            ((GraphicPrimitiveContainer.GraphicPrimitive)object3).setStyle(PrimitiveStyle.SPLITTED_TASK_PART_COMPLETION);
                        }
                    }
                }
                ((GraphicPrimitiveContainer.GraphicPrimitive)object6).setModelObject(task);
            }
            object6 = "";
            if (uIManager.isShowTaskId()) {
                object6 = task.getId() + ",";
            }
            object9 = "";
            if (uIManager.isShowTaskName()) {
                object9 = task.getName() + ",";
            }
            object8 = "";
            if (uIManager.isShowProjectCode()) {
                object8 = task.getProjectTask().getCode() + ",";
            }
            object5 = "";
            if (uIManager.isShowTaskDuration()) {
                object5 = TaskDurationFormat.formatDuration(task, task.isLeaf() ? task.getDuration() : task.getWorkingDuration()) + ",";
            }
            String string = "";
            if (uIManager.isShowTaskWork()) {
                string = TaskWorkDurationFormat.formatWork(task, task.getWork()) + ",";
            }
            String string2 = "";
            if (uIManager.isShowTaskCompletion()) {
                string2 = task.getCompletion() + "%,";
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(uIManager.getDateFormat());
            object = "";
            if (uIManager.isShowTaskStart()) {
                object = simpleDateFormat.format(task.getStartDate()) + ",";
            }
            String string3 = "";
            if (uIManager.isShowTaskEnd()) {
                string3 = simpleDateFormat.format(task.getEndDate()) + ",";
            }
            String string4 = "";
            object4 = "";
            LinkedList<Resource> linkedList = new LinkedList<Resource>();
            if (task.isSplitted()) {
                stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                for (Task task2 : task.getChildList()) {
                    for (Assignment assignment : task2.getAssignments()) {
                        Resource resource = assignment.getResource();
                        n4 = 0;
                        for (Resource resource2 : linkedList) {
                            if (!resource2.equals(resource)) continue;
                            n4 = 1;
                            break;
                        }
                        if (n4 != 0) continue;
                        if (uIManager.isShowAssignmentsName()) {
                            stringBuffer.append(assignment.getResource());
                            stringBuffer.append(" ");
                        }
                        if (uIManager.isShowAssignmentsCode()) {
                            stringBuffer2.append(assignment.getResource().getCode());
                            stringBuffer2.append(" ");
                        }
                        linkedList.add(resource);
                    }
                }
                if (uIManager.isShowAssignmentsName() && stringBuffer.length() > 0) {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
                if (uIManager.isShowAssignmentsCode() && stringBuffer2.length() > 0) {
                    stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
                }
                string4 = stringBuffer.toString();
                object4 = stringBuffer2.toString();
            } else if (task.getAssignmentNumber() != 0) {
                stringBuffer = new StringBuffer();
                StringBuffer stringBuffer3 = new StringBuffer();
                for (Assignment assignment : task.getAssignments()) {
                    if (uIManager.isShowAssignmentsName()) {
                        stringBuffer.append(assignment.getResource());
                        stringBuffer.append(" ");
                    }
                    if (!uIManager.isShowAssignmentsCode()) continue;
                    stringBuffer3.append(assignment.getResource().getCode());
                    stringBuffer3.append(" ");
                }
                if (uIManager.isShowAssignmentsName() && stringBuffer.length() > 0) {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
                if (uIManager.isShowAssignmentsCode() && stringBuffer3.length() > 0) {
                    stringBuffer3.deleteCharAt(stringBuffer3.length() - 1);
                }
                string4 = stringBuffer.toString();
                object4 = stringBuffer3.toString();
            }
            if (uIManager.isShowAssignmentsName()) {
                string4 = string4 + ",";
            }
            if (uIManager.isShowAssignmentsCode()) {
                object4 = (String)object4 + ",";
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append((String)object9);
            stringBuffer.append((String)object8);
            stringBuffer.append((String)object5);
            stringBuffer.append(string);
            stringBuffer.append(string2);
            stringBuffer.append((String)object);
            stringBuffer.append(string3);
            stringBuffer.append(string4);
            stringBuffer.append((String)object4);
            if (stringBuffer.length() != 0) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            double d19 = graphics.getFontMetrics().getStringBounds(stringBuffer.toString(), graphics).getMaxX();
            GraphicPrimitiveContainer.Text text = task.isMilestone() ? this.graphicPrimitiveContainer.createText(d4 + 5.0, i * n, d19, (i + 1) * n, stringBuffer.toString(), false) : this.graphicPrimitiveContainer.createText(d5 + 5.0, i * n, d19, (i + 1) * n, stringBuffer.toString(), false);
            text.setStyle(PrimitiveStyle.ASSIGNED_RESOURCES);
            if (task.getDeadlineDate() == null) continue;
            long l = task.getDeadlineDate().getTime();
            if (bl) {
                l = this.getConventionalDate(l, false, calendarManager);
            }
            long l2 = (long)this.timeScaleManager.getX(l);
            object3 = this.graphicPrimitiveContainer.createImage(l2 - (long)(this.deadlineIcon.getIconWidth() / 2), i * n, this.deadlineIcon, this.highlightedDeadlineIcon, true);
            ((GraphicPrimitiveContainer.GraphicPrimitive)object3).setStyle(PrimitiveStyle.DEADLINE);
            ((GraphicPrimitiveContainer.GraphicPrimitive)object3).setModelObject(task.deadlineHoover);
        }
        BaselineManager baselineManager = BaselineManager.getInstance();
        int n15 = this.treeTable.getRowCount();
        for (int i = 0; i < n15; ++i) {
            TreePath treePath = this.treeTable.getPathForRow(i);
            object2 = (Task)treePath.getLastPathComponent();
            if (((Task)object2).isEmpty()) continue;
            CalendarManager calendarManager = ((Task)object2).getUsedCalendar();
            for (Dependency dependency : ((Task)object2).getSuccessorDependencies()) {
                Task task = dependency.getSuccessor();
                Task task3 = dependency.getPredecessor();
                if (!task.isDescendent((Task)this.treeTable.getTreeTableModel().getRoot())) continue;
                TreePath treePath2 = new TreePath(task.getPath((Task)this.treeTable.getTreeTableModel().getRoot()).toArray());
                int n16 = this.treeTable.getRowForPath(treePath2);
                if (!this.treeTable.isVisible(treePath2) || !(i >= n2 && i <= n3 || n16 >= n2 && n16 <= n3 || n16 < n2 && i > n3) && (i >= n2 || n16 <= n3)) continue;
                CalendarManager calendarManager2 = task.getUsedCalendar();
                double d = ((Task)object2).getEndDate().getTime();
                double d2 = task.getStartDate().getTime();
                switch (dependency.getType()) {
                    case 3: {
                        d = ((Task)object2).getEndDate().getTime();
                        d2 = task.getEndDate().getTime();
                        if (!bl) break;
                        d = this.getConventionalDate((long)d, false, calendarManager);
                        d2 = this.getConventionalDate((long)d2, false, calendarManager2);
                        break;
                    }
                    case 0: {
                        d = ((Task)object2).getEndDate().getTime();
                        d2 = task.getStartDate().getTime();
                        if (!bl) break;
                        d = this.getConventionalDate((long)d, false, calendarManager);
                        d2 = this.getConventionalDate((long)d2, true, calendarManager2);
                        break;
                    }
                    case 2: {
                        d = ((Task)object2).getStartDate().getTime();
                        d2 = task.getEndDate().getTime();
                        if (!bl) break;
                        d = this.getConventionalDate((long)d, true, calendarManager);
                        d2 = this.getConventionalDate((long)d2, false, calendarManager2);
                        break;
                    }
                    case 1: {
                        d = ((Task)object2).getStartDate().getTime();
                        d2 = task.getStartDate().getTime();
                        if (!bl) break;
                        d = this.getConventionalDate((long)d, true, calendarManager);
                        d2 = this.getConventionalDate((long)d2, true, calendarManager2);
                    }
                }
                double d3 = this.timeScaleManager.getX((long)d);
                double d22 = this.timeScaleManager.getX((long)d2);
                int n17 = ((Task)object2).isLeaf() && !((Task)object2).isProject() && baselineManager.isShowBaseline() ? (int)(((double)n - 6.0) / 2.0) : (int)((double)n - 6.0);
                double d23 = task3.isLeaf() && !((Task)object2).isProject() && baselineManager.isShowBaseline() ? (double)(i * n) + 3.0 + (double)(n17 / 2) : (double)(i * n + n / 2);
                double d24 = task3.getId() < task.getId() ? (task.isLeaf() && !((Task)object2).isProject() && baselineManager.isShowBaseline() ? (double)(n16 * n) + 3.0 : (double)(n16 * n) + 3.0) : (double)((n16 + 1) * n) - 3.0;
                object = this.graphicPrimitiveContainer.createMultiLine(d3, d23, d22, d24, true);
                ((GraphicPrimitiveContainer.GraphicPrimitive)object).setModelObject(dependency);
                ((GraphicPrimitiveContainer.GraphicPrimitive)object).setStyle(PrimitiveStyle.DEPENDENCY);
            }
        }
    }

    public Rectangle2D getRectangle(Task task) {
        int n;
        TreePath treePath = new TreePath(task.getPath((Task)this.treeTable.getTreeTableModel().getRoot()).toArray());
        int n2 = this.treeTable.getRowForPath(treePath);
        boolean bl = !this.calendaristic && this.timeScaleManager.getCurrentScaleCombination().getApproximateUnitDuration() >= 86400000L;
        long l = task.getStartDate().getTime();
        long l2 = task.getEndDate().getTime();
        CalendarManager calendarManager = task.getUsedCalendar();
        if (bl) {
            l = this.getConventionalDate(l, true, calendarManager);
            l2 = this.getConventionalDate(l2, false, calendarManager);
        }
        double d = this.timeScaleManager.getX(l);
        double d2 = this.timeScaleManager.getX(l2) - d;
        int n3 = this.treeTable.getRowHeight();
        BaselineManager baselineManager = BaselineManager.getInstance();
        if (task.isLeaf() && baselineManager.isShowBaseline()) {
            n3 = (int)(((double)this.treeTable.getRowHeight() - 6.0) / 2.0);
            n = n2 * this.treeTable.getRowHeight() + 3;
        } else {
            n = n2 * this.treeTable.getRowHeight() + 3;
            n3 = (int)((double)this.treeTable.getRowHeight() - 6.0);
        }
        return new Rectangle2D.Double(d, n, d2, n3);
    }

    public Rectangle2D getCompletionRectangle(Task task) {
        int n;
        int n2;
        TreePath treePath = new TreePath(task.getPath((Task)this.treeTable.getTreeTableModel().getRoot()).toArray());
        int n3 = this.treeTable.getRowForPath(treePath);
        boolean bl = !this.calendaristic && this.timeScaleManager.getCurrentScaleCombination().getApproximateUnitDuration() >= 86400000L;
        long l = task.getStartDate().getTime();
        long l2 = task.getCompletionDate().getTime();
        CalendarManager calendarManager = task.getUsedCalendar();
        if (bl) {
            l = this.getConventionalDate(l, true, calendarManager);
            l2 = task.getCompletion() == 0.0 ? l : this.getConventionalDate(l2, false, calendarManager);
        }
        double d = this.timeScaleManager.getX(l);
        double d2 = this.timeScaleManager.getX(l2) - d;
        BaselineManager baselineManager = BaselineManager.getInstance();
        if (task.isLeaf() && baselineManager.isShowBaseline()) {
            n2 = (int)(((double)this.treeTable.getRowHeight() - 6.0) / 2.0);
            n = n3 * this.treeTable.getRowHeight() + 3;
        } else {
            n = n3 * this.treeTable.getRowHeight() + 3;
            n2 = (int)((double)this.treeTable.getRowHeight() - 6.0);
        }
        return new Rectangle2D.Double(d, n, d2, n2);
    }

    public GraphicPrimitiveContainer.GraphicPrimitive getSelectablePrimitive(int n, int n2, int n3, int n4) {
        GraphicPrimitiveContainer.GraphicPrimitive graphicPrimitive = this.graphicPrimitiveContainer.getSelectablePrimitive(n, n2, n3, n4);
        return graphicPrimitive;
    }

    public GraphicPrimitiveContainer.GraphicPrimitive getSelectablePrimitive(int n, int n2, int n3, int n4, PrimitiveStyle primitiveStyle) {
        GraphicPrimitiveContainer.GraphicPrimitive graphicPrimitive = this.graphicPrimitiveContainer.getSelectablePrimitive(n, n2, n3, n4, primitiveStyle);
        return graphicPrimitive;
    }
}

